/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class IllagerSoulEntity
extends Monster {
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(IllagerSoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANGEL_OR_DEVIL = SynchedEntityData.m_135353_(IllagerSoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity owner;
    private int attackTicks;
    double chargeX;
    double chargeY;
    double chargeZ;
    double targetX;
    double targetY;
    double targetZ;
    private int chargeTime;
    private int oldSwell;
    private int swell;
    private static final int MAX_SWELL = 15;

    public IllagerSoulEntity(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LookAtTargetGoal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(ANGEL_OR_DEVIL, (Object)false);
    }

    protected boolean m_7341_(Entity p_20339_) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    public void m_8119_() {
        LivingEntity var18;
        this.f_19794_ = true;
        if (this.m_5448_() != null) {
            ++this.attackTicks;
            if (this.attackTicks > 50 && this.f_19796_.m_188503_(6) == 0 && this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0) {
                LivingEntity entity = this.m_5448_();
                double x = this.m_20185_() - entity.m_20185_();
                double y = this.m_20186_() - entity.m_20186_();
                double z = this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                float power = 3.5f;
                double motionX = this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                double motionY = this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                double motionZ = this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SOULSCREAM.get(), 3.0f, this.m_6100_());
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.01f, 0, 30);
                this.setTargetPosition(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                this.setCharge(motionX, motionY, motionZ);
            }
        }
        if (this.chargeX != 0.0 && this.chargeY != 0.0 && this.chargeZ != 0.0) {
            ++this.chargeTime;
            this.m_20334_(this.chargeX, this.chargeY, this.chargeZ);
            if (!this.m_9236_().f_46443_) {
                this.setCharging(true);
            }
            if (this.m_20185_() - this.targetX < 1.0 && this.m_20185_() - this.targetX > -1.0 && this.m_20186_() - this.targetY < 1.0 && this.m_20186_() - this.targetY > -1.0 && this.m_20189_() - this.targetZ < 1.0 && this.m_20189_() - this.targetZ > -1.0 || this.chargeTime > 60) {
                if (!this.m_9236_().f_46443_) {
                    CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.01f, 0, 30);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
                }
                this.m_6074_();
            }
        } else {
            this.chargeTime = 0;
            if (!this.m_9236_().f_46443_) {
                this.setCharging(false);
            }
        }
        if (this.f_19797_ > 140) {
            if (!this.m_9236_().f_46443_) {
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.01f, 0, 30);
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
            }
            this.m_6074_();
        }
        super.m_8119_();
        this.m_20242_(true);
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
        this.m_20331_(true);
        this.oldSwell = this.swell++;
        if (this.swell >= 15) {
            this.swell = 15;
        }
        if ((var18 = this.getOwner()) instanceof Mob) {
            Mob mob = (Mob)var18;
            this.m_6710_(mob.m_5448_());
        }
        if (!this.isCharging()) {
            if (this.m_9236_().m_8055_(this.m_20183_().m_7495_()) != Blocks.f_50016_.m_49966_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
            } else if (this.m_20184_().f_82480_ > 0.0) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
        }
        this.stopAttackersFromAttacking();
    }

    public void stopAttackersFromAttacking() {
        List list = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        for (Mob attacker : list) {
            if (attacker.m_21188_() == this && this.getOwner() != null) {
                attacker.m_6703_(this.getOwner());
            }
            if (attacker.m_5448_() != this || this.getOwner() == null) continue;
            attacker.m_6710_(this.getOwner());
        }
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / 13.0f;
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charge) {
        this.f_19804_.m_135381_(CHARGING, (Object)charge);
    }

    public boolean isAngelOrDevil() {
        return (Boolean)this.f_19804_.m_135370_(ANGEL_OR_DEVIL);
    }

    public void setAngelOrDevil(boolean what) {
        this.f_19804_.m_135381_(ANGEL_OR_DEVIL, (Object)what);
    }

    public void setCharge(double x, double y, double z) {
        this.chargeX = x;
        this.chargeY = y;
        this.chargeZ = z;
    }

    public void setTargetPosition(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float p_21017_) {
        return (source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) && super.m_6469_(source, p_21017_);
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.f_20919_ = 19;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public boolean m_21532_() {
        return true;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return IllagerSoulEntity.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return true;
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            if (IllagerSoulEntity.this.m_5448_() != null && !IllagerSoulEntity.this.isCharging()) {
                IllagerSoulEntity.this.m_21563_().m_24960_((Entity)IllagerSoulEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            if (IllagerSoulEntity.this.isCharging()) {
                IllagerSoulEntity.this.m_21563_().m_24950_(IllagerSoulEntity.this.targetX, IllagerSoulEntity.this.targetY, IllagerSoulEntity.this.targetZ, 100.0f, 100.0f);
            }
        }

        public void m_8041_() {
        }
    }
}

