/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.entities.BeeperEntity;
import com.yellowbrossproductions.illageandspillage.entities.EngineerMachine;
import com.yellowbrossproductions.illageandspillage.entities.FactoryMinion;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.PokerEntity;
import com.yellowbrossproductions.illageandspillage.entities.SniperEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FactoryEntity
extends Raider
implements ICanBeAnimated,
EngineerMachine,
IllagerAttack {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(FactoryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IN_MOTION = SynchedEntityData.m_135353_(FactoryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState introAnimationState = new AnimationState();
    public AnimationState spinAnimationState = new AnimationState();
    private int introTicks;
    private int spawnTicks;
    private LivingEntity owner;

    public FactoryEntity(EntityType<? extends Raider> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 30.0);
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof Raider || entity instanceof EngineerMachine || entity instanceof FactoryMinion) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    @Override
    public LivingEntity getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(IN_MOTION, (Object)false);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12600_;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DISPENSER_DESTROY.get();
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12600_;
    }

    public boolean m_37882_() {
        return false;
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        if (this.isInMotion()) {
            this.introTicks = 1;
            this.setAnimationState(2);
            this.setInMotion(false);
        }
        return false;
    }

    public boolean isInMotion() {
        return (Boolean)this.f_19804_.m_135370_(IN_MOTION);
    }

    public void setInMotion(boolean motion) {
        this.f_19804_.m_135381_(IN_MOTION, (Object)motion);
    }

    @Override
    public AnimationState getAnimationState(String var1) {
        if (Objects.equals(var1, "spin")) {
            return this.spinAnimationState;
        }
        if (Objects.equals(var1, "intro")) {
            return this.introAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.spinAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.introAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    private void stopAllAnimationStates() {
        this.spinAnimationState.m_216973_();
        this.introAnimationState.m_216973_();
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
    }

    public List<Raider> getMinions() {
        return this.m_9236_().m_6443_(Raider.class, this.m_20191_().m_82400_(100.0), predicate -> predicate instanceof FactoryMinion && ((FactoryMinion)predicate).getOwner() == this);
    }

    public void m_8119_() {
        if (this.introTicks == 1) {
            this.m_216990_(SoundEvents.f_12600_);
        }
        if (this.introTicks > 0) {
            ++this.introTicks;
        }
        if (this.introTicks == 11) {
            this.m_5496_(SoundEvents.f_12312_, 1.0f, 0.75f);
        }
        if (this.introTicks == 16) {
            this.m_5496_(SoundEvents.f_12312_, 1.0f, 1.0f);
        }
        if (this.introTicks == 21) {
            this.m_5496_(SoundEvents.f_12312_, 1.0f, 1.25f);
        }
        if (!this.isInMotion()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            ++this.spawnTicks;
            if (this.spawnTicks > 60 && this.m_6084_() && this.getMinions().size() < 5) {
                this.m_5496_(SoundEvents.f_11798_, 1.0f, 1.0f);
                int randomSelection = this.f_19796_.m_216339_(0, 3);
                if (!this.m_9236_().f_46443_) {
                    if (randomSelection == 0) {
                        BeeperEntity beeper = (BeeperEntity)((EntityType)ModEntityTypes.Beeper.get()).m_20615_(this.m_9236_());
                        assert (beeper != null);
                        float f = this.f_20883_ * ((float)Math.PI / 180) * 0.25f;
                        float f1 = Mth.m_14089_((float)f);
                        beeper.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_() + (double)f1 * -0.1);
                        beeper.m_20334_(0.0, 0.5, 0.0);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(beeper.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        beeper.setOwner(this);
                        this.m_9236_().m_7967_((Entity)beeper);
                    } else if (randomSelection == 1) {
                        SniperEntity sniper = (SniperEntity)((EntityType)ModEntityTypes.Sniper.get()).m_20615_(this.m_9236_());
                        assert (sniper != null);
                        float f = this.f_20883_ * ((float)Math.PI / 180) * 0.25f;
                        float f1 = Mth.m_14089_((float)f);
                        sniper.m_6034_(this.m_20185_() + (double)f1 * 0.45, this.m_20186_(), this.m_20189_() + (double)f1 * -0.2);
                        sniper.m_20334_(0.0, 0.1, 0.0);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(sniper.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        sniper.setOwner(this);
                        this.m_9236_().m_7967_((Entity)sniper);
                    } else {
                        PokerEntity poker = (PokerEntity)((EntityType)ModEntityTypes.Poker.get()).m_20615_(this.m_9236_());
                        assert (poker != null);
                        float f = this.f_20883_ * ((float)Math.PI / 180) * 0.25f;
                        float f1 = Mth.m_14089_((float)f);
                        poker.m_6034_(this.m_20185_() + (double)f1 * -0.55, this.m_20186_(), this.m_20189_() + (double)f1 * 0.05);
                        poker.m_20334_(0.0, 0.5, 0.0);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(poker.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        poker.setOwner(this);
                        poker.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
                        poker.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                        poker.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                        this.m_9236_().m_7967_((Entity)poker);
                    }
                }
                this.spawnTicks = 0;
            }
        }
        if (this.m_20096_() && this.isInMotion()) {
            if (this.introTicks < 1) {
                this.introTicks = 1;
            }
            this.setAnimationState(2);
            this.setInMotion(false);
        }
        super.m_8119_();
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        if (this.m_9236_().f_46443_) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
        this.f_20919_ = 19;
    }
}

