/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import com.yellowbrossproductions.illageandspillage.entities.goal.StareAtDeadFreakGoal;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.particle.ParticleRegisterer;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class EyesoreEntity
extends Monster
implements ICanBeAnimated,
IllagerAttack {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(EyesoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(EyesoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SCARED = SynchedEntityData.m_135353_(EyesoreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState slitherAnimationState = new AnimationState();
    public AnimationState flyAnimationState = new AnimationState();
    private LivingEntity owner = null;
    private BlockPos targetPos;

    public EyesoreEntity(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new StareAtDeadFreakGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AvoidRagnoGoal((PathfinderMob)this, 16.0f, 0.65f, 0.6f));
        this.f_21345_.m_25352_(1, (Goal)new SlitherGoal(this, 0.5));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.75).m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 24.0);
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    public LivingEntity getOwner() {
        return this.owner;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_EYESORE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_EYESORE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_EYESORE_DEATH.get();
    }

    public void m_6710_(@Nullable LivingEntity p_21544_) {
        if (this.owner != null && this.owner.m_6084_() && this.owner instanceof Mob && p_21544_ == ((Mob)this.owner).m_5448_()) {
            super.m_6710_(p_21544_);
        } else if (this.owner == null || !this.owner.m_6084_()) {
            super.m_6710_(p_21544_);
        }
    }

    public void setAnimationState(int state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(SCARED, (Object)false);
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        if (this.isFlying()) {
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_EYESORE_LAND.get(), 2.0f, this.m_6100_());
            this.setFlying(false);
            return false;
        }
        return super.m_142535_(p_225503_1_, p_225503_2_, p_147189_);
    }

    @Override
    public AnimationState getAnimationState(String var1) {
        if (Objects.equals(var1, "fly")) {
            return this.flyAnimationState;
        }
        return Objects.equals(var1, "slither") ? this.slitherAnimationState : new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.slitherAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.flyAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    private void stopAllAnimationStates() {
        this.slitherAnimationState.m_216973_();
        this.flyAnimationState.m_216973_();
    }

    @Override
    public float getAnimationSpeed() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) == 1 ? 2.5f : 1.0f;
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        boolean superHurt = super.m_6469_(p_37849_, p_37850_);
        if (superHurt) {
            this.makeBloodParticles();
        }
        return superHurt;
    }

    public void makeCryParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                double d0 = -0.5 + this.f_19796_.m_188583_();
                double d1 = -0.5 + this.f_19796_.m_188583_();
                double d2 = -0.5 + this.f_19796_.m_188583_();
                packet.queueParticle((ParticleOptions)ParticleTypes.f_123769_, false, new Vec3(this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5)), new Vec3(d0, d1, d2));
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeBloodParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 5; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (1.0 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleRegisterer.BLOOD_PARTICLES.get(), false, new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isFlying() && (Integer)this.f_19804_.m_135370_(ANIMATION_STATE) != 1) {
            this.setAnimationState(1);
        }
        BlockPos blockPos = this.targetPos = this.m_5448_() != null && this.m_5448_().m_6084_() ? this.m_5448_().m_20097_() : null;
        if (this.owner != null && this.owner.m_6084_() && this.owner instanceof Mob && this.m_5448_() != ((Mob)this.owner).m_5448_()) {
            this.m_6710_(((Mob)this.owner).m_5448_());
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.7));
        for (LivingEntity hit : list) {
            if (!this.m_21515_() || !EntityUtil.canHurtThisMob((Entity)hit, (Mob)this) || hit instanceof EyesoreEntity) continue;
            this.dealDamage(hit);
        }
        if (this.m_20096_()) {
            this.setFlying(false);
        }
        if (this.isScared()) {
            this.makeCryParticles();
        }
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
        this.setAnimationState(flying ? 2 : 1);
    }

    public boolean isScared() {
        return (Boolean)this.f_19804_.m_135370_(SCARED);
    }

    public void setScared(boolean scared) {
        this.f_19804_.m_135381_(SCARED, (Object)scared);
    }

    protected void dealDamage(LivingEntity entity) {
        if (this.m_6084_() && this.m_142582_((Entity)entity) && entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_))) {
            double d2 = entity.m_21133_(Attributes.f_22278_);
            double d1 = Math.max(0.0, 1.0 - d2);
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)0.4f * d1, 0.0));
            this.m_5496_(SoundEvents.f_12384_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19970_((LivingEntity)this, (Entity)entity);
        }
    }

    public boolean shouldAvoidRagno() {
        List ragnos = this.m_9236_().m_45976_(RagnoEntity.class, this.m_20191_().m_82400_(11.0));
        for (RagnoEntity ragno : ragnos) {
            if (!ragno.isCrazy()) continue;
            return true;
        }
        return false;
    }

    class AvoidRagnoGoal
    extends AvoidEntityGoal {
        public AvoidRagnoGoal(PathfinderMob p_25033_, float p_25035_, double p_25036_, double p_25037_) {
            super(p_25033_, RagnoEntity.class, p_25035_, p_25036_, p_25037_, predicate -> EntityUtil.isEntityCrazyRagno((Entity)predicate));
        }

        public void m_8056_() {
            super.m_8056_();
            EyesoreEntity.this.setScared(true);
        }

        public void m_8041_() {
            super.m_8041_();
            EyesoreEntity.this.setScared(false);
        }
    }

    class SlitherGoal
    extends Goal {
        protected final EyesoreEntity eyesore;
        protected final double speedModifier;
        protected double posX;
        protected double posY;
        protected double posZ;

        public SlitherGoal(EyesoreEntity p_25691_, double p_25692_) {
            this.eyesore = p_25691_;
            this.speedModifier = p_25692_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            Vec3 vec3;
            if (this.eyesore.shouldAvoidRagno()) {
                return false;
            }
            BlockPos targetPos = EyesoreEntity.this.targetPos;
            if (targetPos == null || this.eyesore.m_20182_().m_82557_(targetPos.m_252807_()) <= 256.0) {
                vec3 = DefaultRandomPos.m_148403_((PathfinderMob)this.eyesore, (int)5, (int)4);
            } else {
                EyesoreEntity mob = this.eyesore.m_5448_() != null ? this.eyesore.m_5448_() : this.eyesore;
                vec3 = mob.m_20097_().m_252807_();
            }
            if (targetPos != null && vec3 != null) {
                this.posX = vec3.f_82479_;
                this.posY = vec3.f_82480_;
                this.posZ = vec3.f_82481_;
                return true;
            }
            if (targetPos == null && vec3 != null) {
                this.posX = vec3.f_82479_;
                this.posY = vec3.f_82480_;
                this.posZ = vec3.f_82481_;
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.eyesore.m_21573_().m_26519_(this.posX, this.posY, this.posZ, this.speedModifier);
        }

        public boolean m_8045_() {
            return !this.eyesore.m_21573_().m_26571_() && !this.eyesore.shouldAvoidRagno();
        }
    }
}

