/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.EngineerMachine;
import com.yellowbrossproductions.illageandspillage.entities.FactoryEntity;
import com.yellowbrossproductions.illageandspillage.entities.FactoryMinion;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.entities.goal.FactoryMinionFollowOwnerGoal;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class BeeperEntity
extends Raider
implements FactoryMinion,
IllagerAttack {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(BeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.m_135353_(BeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.m_135353_(BeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> PARTIAL_TICKS = SynchedEntityData.m_135353_(BeeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public int lastActiveTime;
    public int timeSinceIgnited;
    public int fuseTime = 30;
    private float explosionRadius = 1.2f;
    private FactoryEntity owner;

    public BeeperEntity(EntityType<? extends Raider> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BeeperSwellGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new FactoryMinionFollowOwnerGoal(this, 1.0, 2.0f, 100.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof Raider || entity instanceof EngineerMachine || entity instanceof FactoryMinion) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12600_;
    }

    public boolean m_37882_() {
        return false;
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        boolean flag = super.m_142535_(distance, damageMultiplier, source);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)-1);
        this.f_19804_.m_135372_(POWERED, (Object)false);
        this.f_19804_.m_135372_(IGNITED, (Object)false);
        this.f_19804_.m_135372_(PARTIAL_TICKS, (Object)Float.valueOf(1.0f));
    }

    public float getPartialTicks() {
        return ((Float)this.f_19804_.m_135370_(PARTIAL_TICKS)).floatValue();
    }

    public void setPartialTicks(float partialTicks) {
        this.f_19804_.m_135381_(PARTIAL_TICKS, (Object)Float.valueOf(partialTicks));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("Fuse", (short)this.fuseTime);
        compound.m_128350_("ExplosionRadius", this.explosionRadius);
        compound.m_128379_("Ignited", this.hasIgnited());
        if (((Boolean)this.f_19804_.m_135370_(POWERED)).booleanValue()) {
            compound.m_128379_("Powered", true);
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Fuse", 99)) {
            this.fuseTime = compound.m_128448_("Fuse");
        }
        if (compound.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compound.m_128457_("ExplosionRadius");
        }
        if (compound.m_128471_("Ignited")) {
            this.ignite();
        }
        this.f_19804_.m_135381_(POWERED, (Object)compound.m_128471_("Powered"));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.8f;
    }

    protected void explode() {
        if (!this.m_9236_().m_5776_()) {
            this.f_20890_ = true;
            this.makeFireParticles();
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius, Level.ExplosionInteraction.NONE);
            this.m_146870_();
            this.spawnLingeringCloud();
            for (LivingEntity hit : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.75))) {
                hit.m_20254_(5);
            }
        }
    }

    public void makeFireParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 15; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123744_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12600_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12600_;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.m_5496_(SoundEvents.f_12512_, 1.0f, 0.5f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_ENGINEER_BEEPER_BEEP.get(), 1.0f, 1.0f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.m_8119_();
    }

    public boolean m_7327_(Entity p_21372_) {
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42409_) {
            this.m_9236_().m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().m_5776_()) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)player, p_213625_1_ -> p_213625_1_.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setCreeperState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public boolean hasIgnited() {
        return (Boolean)this.f_19804_.m_135370_(IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(IGNITED, (Object)true);
    }

    protected void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloudentity.m_19712_(1.0f);
            areaeffectcloudentity.m_19732_(-0.5f);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
            areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
            for (MobEffectInstance effectinstance : collection) {
                areaeffectcloudentity.m_19716_(new MobEffectInstance(effectinstance));
            }
            this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
        }
    }

    @Override
    public FactoryEntity getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(FactoryEntity owner) {
        this.owner = owner;
    }

    private static class BeeperSwellGoal
    extends Goal {
        private final BeeperEntity swellingBeeper;
        private LivingEntity beeperAttackTarget;

        public BeeperSwellGoal(BeeperEntity entityIn) {
            this.swellingBeeper = entityIn;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.swellingBeeper.m_5448_();
            return this.swellingBeeper.getCreeperState() > 0 || livingEntity != null && this.swellingBeeper.m_20280_((Entity)livingEntity) < 4.0;
        }

        public void m_8056_() {
            this.beeperAttackTarget = this.swellingBeeper.m_5448_();
        }

        public void m_8041_() {
            this.beeperAttackTarget = null;
        }

        public void m_8037_() {
            if (this.beeperAttackTarget == null) {
                this.swellingBeeper.setCreeperState(-1);
            } else if (this.swellingBeeper.m_20280_((Entity)this.beeperAttackTarget) > 6.25) {
                this.swellingBeeper.setCreeperState(-1);
            } else if (!this.swellingBeeper.m_21574_().m_148306_((Entity)this.beeperAttackTarget)) {
                this.swellingBeeper.setCreeperState(-1);
            } else {
                this.swellingBeeper.setCreeperState(1);
                this.swellingBeeper.m_21573_().m_5624_((Entity)this.beeperAttackTarget, 0.8);
            }
        }
    }
}

