/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.sound;

import com.yellowbrossproductions.illageandspillage.client.sound.BossMusicPlayer;
import com.yellowbrossproductions.illageandspillage.client.tool.ControlledAnimation;
import com.yellowbrossproductions.illageandspillage.entities.OldRagnoEntity;
import com.yellowbrossproductions.illageandspillage.entities.RagnoEntity;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.raid.Raider;

public class BossMusicSound
extends AbstractTickableSoundInstance {
    private Raider boss;
    private int ticksExisted = 0;
    private int timeUntilFade;
    private final SoundEvent soundEvent;
    ControlledAnimation volumeControl;
    private boolean shouldChangeMusic;

    public BossMusicSound(SoundEvent sound, Raider boss) {
        super(sound, SoundSource.RECORDS, boss.m_217043_());
        this.boss = boss;
        this.soundEvent = sound;
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119575_ = boss.m_20185_();
        this.f_119576_ = boss.m_20186_();
        this.f_119577_ = boss.m_20189_();
        this.volumeControl = new ControlledAnimation(40);
        this.volumeControl.setTimer(20);
        this.f_119573_ = this.volumeControl.getAnimationFraction();
        this.timeUntilFade = 80;
        this.f_119578_ = false;
    }

    public boolean m_7767_() {
        return BossMusicPlayer.bossMusic == this;
    }

    public void m_7788_() {
        if (this.boss != null && this.boss.m_6084_() && !this.boss.m_20067_()) {
            this.volumeControl.increaseTimer();
            this.timeUntilFade = 60;
        } else {
            if (this.boss != null && !this.boss.m_6084_()) {
                this.timeUntilFade = 0;
            }
            this.boss = null;
            if (this.timeUntilFade > 0) {
                --this.timeUntilFade;
            } else {
                this.volumeControl.decreaseTimer();
            }
        }
        if (this.boss instanceof RagnoEntity && this.soundEvent == IllageAndSpillageSoundEvents.ENTITY_RAGNO_TRANS.get() && this.ticksExisted >= 518) {
            this.shouldChangeMusic = true;
            return;
        }
        if (this.boss instanceof OldRagnoEntity && this.soundEvent == IllageAndSpillageSoundEvents.ENTITY_RAGNO_TRANS.get() && this.ticksExisted >= 518) {
            this.shouldChangeMusic = true;
            return;
        }
        if ((double)this.volumeControl.getAnimationFraction() < 0.025) {
            this.m_119609_();
            BossMusicPlayer.bossMusic = null;
        }
        this.f_119573_ = this.volumeControl.getAnimationFraction() * 0.4f;
        if (this.ticksExisted % 100 == 0) {
            Minecraft.m_91087_().m_91397_().m_120186_();
        }
        ++this.ticksExisted;
    }

    public boolean shouldChangeMusic() {
        return this.shouldChangeMusic;
    }

    public void resetChangeMusic() {
        this.shouldChangeMusic = false;
    }

    public void setBoss(Raider boss) {
        this.boss = boss;
    }

    public Raider getBoss() {
        return this.boss;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }
}

