/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Calendar;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class PokerModel<T extends Entity>
extends HierarchicalModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "poker"), "main");
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart arm2;
    private final ModelPart arm1;
    private final ModelPart leg2;
    private final ModelPart leg1;

    public PokerModel(ModelPart root) {
        this.root = root;
        this.all = this.root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.arm2 = this.body.m_171324_("arm2");
        this.arm1 = this.body.m_171324_("arm1");
        this.leg2 = this.all.m_171324_("leg2");
        this.leg1 = this.all.m_171324_("leg1");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(14, 12).m_171488_(-2.0f, -5.0f, -1.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-6.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -7.0f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(24, 8).m_171488_(-1.0f, -3.0f, -4.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(0.0f, -7.3f, -9.7f, 0.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.5f, (float)7.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition birthday = head.m_171599_("birthday", CubeListBuilder.m_171558_().m_171514_(12, 32).m_171488_(-1.5f, -9.3333f, 6.0833f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-1.0f, -12.3333f, 6.5833f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(25, 29).m_171488_(0.5f, -15.3333f, 6.5833f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-0.6667f, (float)-8.0833f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        birthday.m_171599_("thingy", CubeListBuilder.m_171558_().m_171514_(25, 32).m_171488_(-1.0f, -15.3333f, 8.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(20, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-4.0f, (float)0.0f, (float)-0.01f, (float)0.0082f, (float)0.0182f));
        body.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(8, 19).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)-4.0f, (float)0.0f, (float)0.0143f, (float)0.0271f, (float)0.0074f));
        all.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-6.0f, (float)0.0f));
        all.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-1.5f, (float)-6.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)40);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        Calendar calendar = Calendar.getInstance();
        this.head.m_171324_((String)"birthday").f_104207_ = calendar.get(2) == 1 && calendar.get(5) < 8;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.leg1.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.leg2.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        PokerModel.animatePokerArms(this.arm1, this.arm2, this.head, this.f_102608_);
    }

    public static void animatePokerArms(ModelPart rightArm, ModelPart leftArm, ModelPart head, float attackTime) {
        float f = Mth.m_14031_((float)(attackTime * (float)(-Math.PI)));
        float f1 = Mth.m_14031_((float)((1.0f - (1.0f - attackTime) * (1.0f - attackTime)) * (float)Math.PI));
        rightArm.f_104204_ = -0.45f + head.f_104204_ + (0.1f - f);
        leftArm.f_104204_ = 0.45f + head.f_104204_ - (0.1f - f);
        rightArm.f_104203_ = -1.5707964f + head.f_104203_ + 0.1f + (f * 1.2f - f1 * 0.4f);
        leftArm.f_104203_ = -1.5f + head.f_104203_ + (f * 1.2f - f1 * 0.4f);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm p_191216_1_) {
        return p_191216_1_ == HumanoidArm.LEFT ? this.arm2 : this.arm1;
    }

    public void m_6002_(HumanoidArm p_102108_, PoseStack p_102109_) {
        this.m_142109_().m_104299_(p_102109_);
        this.all.m_104299_(p_102109_);
        this.body.m_104299_(p_102109_);
        this.getArm(p_102108_).m_104299_(p_102109_);
        p_102109_.m_85841_(0.55f, 0.55f, 0.55f);
    }
}

