/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.client.model.animation.HinderAnimation;
import com.yellowbrossproductions.illageandspillage.entities.HinderEntity;
import java.util.Calendar;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class HinderModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "hinder"), "main");
    private final ModelPart root;
    private final ModelPart thingy2;
    private final ModelPart thingy;
    private final ModelPart head;
    private final ModelPart stick;
    private final ModelPart propeler;
    private final ModelPart base;

    public HinderModel(ModelPart root) {
        this.root = root;
        this.thingy2 = this.root.m_171324_("thingy2");
        this.thingy = this.root.m_171324_("thingy");
        this.head = root.m_171324_("head");
        this.base = this.root.m_171324_("base");
        this.stick = this.head.m_171324_("stick");
        this.propeler = this.stick.m_171324_("propeler");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("thingy2", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171480_().m_171488_(-5.0f, -7.5f, -5.0f, 10.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.m_171599_("thingy", CubeListBuilder.m_171558_().m_171514_(28, 0).m_171488_(-5.0f, -9.5f, -5.0f, 10.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, -4.75f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 48).m_171488_(-4.0f, -6.75f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 62).m_171488_(-6.0f, 4.25f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.75f, (float)0.0f));
        head.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171488_(-6.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)5.25f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        head.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-4.0f, -1.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.25f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        PartDefinition stick = head.m_171599_("stick", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.75f, (float)0.0f));
        PartDefinition propeler = stick.m_171599_("propeler", CubeListBuilder.m_171558_().m_171514_(-18, 0).m_171488_(-9.0f, 0.0f, -9.0f, 18.0f, 0.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.1f, (float)0.0f));
        PartDefinition birthday = propeler.m_171599_("birthday", CubeListBuilder.m_171558_().m_171514_(72, 26).m_171488_(-2.0f, -9.3333f, 6.0833f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(60, 26).m_171488_(-1.5f, -12.3333f, 6.5833f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(85, 23).m_171488_(0.0f, -15.3333f, 6.5833f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.4333f, (float)-8.0833f));
        birthday.m_171599_("thingy3", CubeListBuilder.m_171558_().m_171514_(85, 26).m_171488_(-1.5f, -15.3333f, 8.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("base", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-5.0f, -4.0f, -5.0f, 10.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(32, 48).m_171488_(-4.0f, -6.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity instanceof HinderEntity) {
            HinderEntity hinder = (HinderEntity)entity;
            this.m_233385_(hinder.getAnimationState("intro"), HinderAnimation.SPAWN, ageInTicks, hinder.getAnimationSpeed());
            this.m_233385_(hinder.getAnimationState("idle"), HinderAnimation.IDLE, ageInTicks, hinder.getAnimationSpeed());
            Calendar calendar = Calendar.getInstance();
            boolean bl = this.propeler.m_171324_((String)"birthday").f_104207_ = calendar.get(2) == 1 && calendar.get(5) < 8;
            if (hinder.isInMotion()) {
                this.base.f_104203_ = ageInTicks * 25.0f * ((float)Math.PI / 180);
                this.base.f_104204_ = ageInTicks * 15.0f * ((float)Math.PI / 180);
                this.base.f_104205_ = ageInTicks * 20.0f * ((float)Math.PI / 180);
                this.head.f_104207_ = false;
                this.thingy.f_104207_ = false;
                this.thingy2.f_104207_ = false;
            } else {
                this.base.f_104203_ = 0.0f;
                this.base.f_104204_ = 0.0f;
                this.base.f_104205_ = 0.0f;
                this.head.f_104207_ = true;
                this.thingy.f_104207_ = true;
                this.thingy2.f_104207_ = true;
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.thingy2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.thingy.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.base.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

