/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.projectile;

import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;

public class Player_Ceraunus_Entity
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Boolean> RETURN = SynchedEntityData.m_135353_(Player_Ceraunus_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> Y_ROT_OLD = SynchedEntityData.m_135353_(Player_Ceraunus_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_ROT_OLD = SynchedEntityData.m_135353_(Player_Ceraunus_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public Player_Ceraunus_Entity(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public Player_Ceraunus_Entity(EntityType type, double x, double y, double z, Level worldIn) {
        this(type, worldIn);
        this.m_6034_(x, y, z);
    }

    public Player_Ceraunus_Entity(Level worldIn, LivingEntity shooter) {
        this((EntityType)ModEntities.PLAYER_CERAUNUS.get(), shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_(), worldIn);
        this.m_5602_((Entity)shooter);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RETURN, (Object)false);
        this.f_19804_.m_135372_(Y_ROT_OLD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(X_ROT_OLD, (Object)Float.valueOf(0.0f));
    }

    public boolean getReturn() {
        return (Boolean)this.f_19804_.m_135370_(RETURN);
    }

    public void setReturn(boolean weapon) {
        this.f_19804_.m_135381_(RETURN, (Object)weapon);
    }

    public float getYrotOld() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT_OLD)).floatValue();
    }

    public void setYrotOld(float rot) {
        this.f_19804_.m_135381_(Y_ROT_OLD, (Object)Float.valueOf(rot));
    }

    public float getXrotOld() {
        return ((Float)this.f_19804_.m_135370_(X_ROT_OLD)).floatValue();
    }

    public void setXrotOld(float rot) {
        this.f_19804_.m_135381_(X_ROT_OLD, (Object)Float.valueOf(rot));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setReturn(tag.m_128471_("Return"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Return", this.getReturn());
    }

    public void m_8119_() {
        super.m_8119_();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.getReturn()) {
                if (!this.isAcceptibleReturnOwner()) {
                    this.m_146870_();
                } else {
                    this.m_36790_(true);
                    Vec3 vec3 = owner.m_146892_().m_82546_(this.m_20182_());
                    this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * 3.0, this.m_20189_());
                    this.m_146922_(this.getYrotOld());
                    if (this.m_9236_().f_46443_) {
                        this.f_19791_ = this.m_20186_();
                    } else if (this.m_20270_((Entity)owner) < 3.0f) {
                        this.m_146870_();
                    }
                    double d0 = 0.2;
                    this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                }
            }
        } else {
            this.m_146870_();
        }
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        return entity == null || !entity.m_6084_() ? false : !(entity instanceof ServerPlayer) || !entity.m_5833_();
    }

    protected void m_5790_(EntityHitResult p_37573_) {
        Entity entity1;
        DamageSource damagesource;
        Entity entity = p_37573_.m_82443_();
        if (entity.m_6469_(damagesource = CMDamageTypes.causeStormBringerDamage((Entity)this, (Entity)((entity1 = this.m_19749_()) == null ? this : entity1)), (float)this.m_36789_())) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.doKnockback(livingentity, damagesource);
                this.m_7761_(livingentity);
            }
        }
    }

    protected void m_8060_(BlockHitResult p_37573_) {
        super.m_8060_(p_37573_);
        double DeltaMovementX = this.f_19796_.m_188583_() * 0.1;
        double DeltaMovementY = this.f_19796_.m_188583_() * 0.02;
        double DeltaMovementZ = this.f_19796_.m_188583_() * 0.1;
        if (this.m_9236_().f_46443_) {
            for (int i1 = 0; i1 < 5 + this.f_19796_.m_188503_(2); ++i1) {
                this.m_9236_().m_7106_((ParticleOptions)ModParticle.SPARK.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected boolean m_142470_(Player player) {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    protected float m_6882_() {
        return 0.95f;
    }

    protected void doKnockback(LivingEntity entity, DamageSource damageSource) {
        double d0 = 1.5;
        double d1 = Math.max(0.0, 1.0 - entity.m_21133_(Attributes.f_22278_) * 1.0 / 3.0);
        Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(d0 * 0.6 * d1);
        if (vec3.m_82556_() > 0.0) {
            entity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            this.setXrotOld(this.m_146909_());
            this.setYrotOld(this.m_146908_());
            ScreenShake_Entity.ScreenShake(this.m_9236_(), this.m_20182_(), 25.0f, 0.03f, 0, 20);
            this.setReturn(true);
        }
    }

    public boolean m_6072_() {
        return false;
    }

    protected float getGravity() {
        return 0.08f;
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)ModSounds.HEAVY_SMASH.get();
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.m_19749_() != null ? this.m_19749_().m_19879_() : -1);
    }

    public void readSpawnData(FriendlyByteBuf buf) {
        Entity e = this.m_9236_().m_6815_(buf.readInt());
        if (e instanceof LivingEntity) {
            this.m_5602_(e);
        }
    }
}

