/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.effect;

import com.github.L_Ender.cataclysm.client.particle.Custom_Poof_Particle;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Wave_Entity
extends Entity {
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(Wave_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_TICKS = SynchedEntityData.m_135353_(Wave_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> Y_ROT = SynchedEntityData.m_135353_(Wave_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Wave_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(Wave_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public AnimationState SpawnAnimationState = new AnimationState();
    public AnimationState DespawnAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;
    private boolean sentEvent;
    private boolean clientSideAttackEnded;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lyr;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;

    public Wave_Entity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public Wave_Entity(Level level, LivingEntity shooter, int life, float damage) {
        this((EntityType)ModEntities.WAVE.get(), level);
        this.setOwner(shooter);
        this.setMaxTicks(life);
        this.setDamage(damage);
        this.setLifespan(0);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    public void setOwner(@Nullable LivingEntity living) {
        this.owner = living;
        this.ownerUUID = living == null ? null : living.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFESPAN, (Object)0);
        this.f_19804_.m_135372_(MAX_TICKS, (Object)0);
        this.f_19804_.m_135372_(Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public AnimationState getAnimationState(String input) {
        if (input == "spawn") {
            return this.SpawnAnimationState;
        }
        if (input == "idle") {
            return this.idleAnimationState;
        }
        if (input == "despawn") {
            return this.DespawnAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (STATE.equals(p_21104_)) {
            switch (this.getState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.SpawnAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.DespawnAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.DespawnAnimationState.m_216973_();
        this.idleAnimationState.m_216973_();
        this.SpawnAnimationState.m_216973_();
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        if (tag.m_128441_("Lifespan")) {
            this.setLifespan(tag.m_128451_("Lifespan"));
        }
        if (tag.m_128441_("Maxticks")) {
            this.setMaxTicks(tag.m_128451_("Maxticks"));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        if (this.ownerUUID != null) {
            compoundTag.m_128362_("Owner", this.ownerUUID);
        }
        compoundTag.m_128405_("Lifespan", this.getLifespan());
        compoundTag.m_128405_("Maxticks", this.getMaxTicks());
    }

    public float m_146908_() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue();
    }

    public void m_146922_(float f) {
        this.f_19804_.m_135381_(Y_ROT, (Object)Float.valueOf(f));
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int time) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)time);
    }

    public int getMaxTicks() {
        return (Integer)this.f_19804_.m_135370_(MAX_TICKS);
    }

    public void setMaxTicks(int time) {
        this.f_19804_.m_135381_(MAX_TICKS, (Object)time);
    }

    private void spawnParticleAt(float yOffset, float zOffset, float xOffset, ParticleOptions particleType) {
        Vec3 vec3 = new Vec3((double)xOffset, (double)yOffset, (double)zOffset).m_82524_((float)Math.toRadians(-this.m_146908_()));
        this.m_9236_().m_7106_(particleType, this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_, this.m_20184_().f_82479_, (double)0.1f, this.m_20184_().f_82481_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20068_() && !this.m_20072_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.04f, 0.0));
        }
        if (this.getState() == 1 && this.getLifespan() >= 5) {
            this.setState(2);
        }
        if (this.getState() == 2) {
            if (this.getLifespan() >= this.getMaxTicks() - 30 && !this.sentEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentEvent = true;
            }
            if (this.getLifespan() >= this.getMaxTicks() - 10) {
                this.setState(3);
            }
        }
        this.setLifespan(this.getLifespan() + 1);
        if (this.getLifespan() >= this.getMaxTicks()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        float f = Math.max(1.0f - (float)this.getLifespan() / (1.0f * (float)this.getMaxTicks()), 0.0f);
        Vec3 directionVec = new Vec3(0.0, 0.0, (double)(f * f * 0.1f)).m_82524_((float)Math.toRadians(-this.m_146908_()));
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146922_(Mth.m_14177_((float)((float)this.lyr)));
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
            if (!this.clientSideAttackEnded) {
                for (int particleCount = 0; particleCount < 2; ++particleCount) {
                    for (int i = 0; i < 2; ++i) {
                        float xOffset = (float)(i - 1) / 2.0f + 0.25f + (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
                        int rand = this.f_19796_.m_188503_(20);
                        this.spawnParticleAt(0.1f + this.f_19796_.m_188501_() * 0.2f, 0.7f, xOffset * 3.5f, new Custom_Poof_Particle.PoofData(76 + rand, 147 + rand, 173 + rand, 0.1f));
                    }
                }
            }
        } else {
            this.m_20090_();
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.attackEntities(1.5, Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), -Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))));
        }
        Vec3 vec3 = this.m_20184_().m_82490_((double)0.9f).m_82549_(directionVec);
        this.m_6478_(MoverType.SELF, vec3);
        this.m_20256_(vec3.m_82542_((double)0.99f, (double)0.98f, (double)0.99f));
    }

    protected void attackEntities(double strength, double x, double z) {
        AABB bashBox = this.m_20191_().m_82400_((double)0.01f);
        DamageSource source = this.m_269291_().m_269299_((Entity)this, this.owner);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, bashBox)) {
            if (this.m_7307_((Entity)entity) || this.owner != null && (this.owner.equals((Object)entity) || this.owner.m_7307_((Entity)entity))) continue;
            boolean flag = entity.m_6469_(source, this.getDamage());
            if (flag) {
                MobEffectInstance effectinstance1 = entity.m_21124_((MobEffect)ModEffect.EFFECTWETNESS.get());
                int i = 1;
                if (effectinstance1 != null) {
                    i += effectinstance1.m_19564_();
                    entity.m_6234_((MobEffect)ModEffect.EFFECTWETNESS.get());
                } else {
                    --i;
                }
                i = Mth.m_14045_((int)i, (int)0, (int)4);
                MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTWETNESS.get(), 200, i, false, true, true);
                entity.m_7292_(effectinstance);
            }
            entity.f_19812_ = true;
            Vec3 vec3 = entity.m_20184_();
            while (x * x + z * z < (double)1.0E-5f) {
                x = (Math.random() - Math.random()) * 0.01;
                z = (Math.random() - Math.random()) * 0.01;
            }
            double playerSize = 1.08;
            double entitySize = entity.m_20205_() * entity.m_20206_();
            double scale = playerSize / Math.max(0.1, entitySize);
            double knockbackScale = Math.min(scale, 1.5);
            double adjustedStrength = strength * knockbackScale;
            Vec3 knockback = new Vec3(x, 0.0, z).m_82541_().m_82490_(adjustedStrength);
            entity.m_20334_(vec3.f_82479_ / 2.0 - knockback.f_82479_, entity.m_20096_() ? Math.min(0.5, vec3.f_82480_ / 2.0 + strength) : vec3.f_82480_, vec3.f_82481_ / 2.0 - knockback.f_82481_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.clientSideAttackEnded = true;
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean bool) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lyr = yr;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }
}

