/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.effect;

import com.github.L_Ender.cataclysm.client.particle.LightningParticle;
import com.github.L_Ender.cataclysm.client.particle.LightningStormParticle;
import com.github.L_Ender.cataclysm.client.particle.RingParticle;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class Lightning_Storm_Entity
extends Entity {
    public static final int STRIKE = 10;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(Lightning_Storm_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HPDAMAGE = SynchedEntityData.m_135353_(Lightning_Storm_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(Lightning_Storm_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(Lightning_Storm_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.m_135353_(Lightning_Storm_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public Lightning_Storm_Entity(EntityType<? extends Lightning_Storm_Entity> entityType, Level level) {
        super(entityType, level);
    }

    public Lightning_Storm_Entity(Level worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, float damage, float Hpdamage, LivingEntity casterIn, float size) {
        this((EntityType<? extends Lightning_Storm_Entity>)((EntityType)ModEntities.LIGHTNING_STORM.get()), worldIn);
        this.setDelay(p_i47276_9_);
        this.setCaster(casterIn);
        this.setDamage(damage);
        this.setHpDamage(Hpdamage);
        this.m_146922_(p_i47276_8_ * 57.295776f);
        this.m_6034_(x, y, z);
        this.setSize(size);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HPDAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFESPAN, (Object)0);
        this.f_19804_.m_135372_(DELAY, (Object)0);
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int lifespan) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)lifespan);
    }

    public int getDelay() {
        return (Integer)this.f_19804_.m_135370_(DELAY);
    }

    public void setDelay(int delay) {
        this.f_19804_.m_135381_(DELAY, (Object)delay);
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float size) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(SIZE, (Object)Float.valueOf(Mth.m_14036_((float)size, (float)1.0f, (float)5.0f)));
        }
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.owner = p_190549_1_;
        this.ownerUUID = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getHpDamage() {
        return ((Float)this.f_19804_.m_135370_(HPDAMAGE)).floatValue();
    }

    public void setHpDamage(float damage) {
        this.f_19804_.m_135381_(HPDAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean m_6783_(double distance) {
        double d0 = 64.0 * Lightning_Storm_Entity.m_20150_();
        return distance < d0 * d0;
    }

    public void m_7350_(EntityDataAccessor<?> p_19729_) {
        if (SIZE.equals(p_19729_)) {
            this.m_6210_();
        }
        super.m_7350_(p_19729_);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_((float)(this.getSize() * 0.5f), (float)(this.getSize() * 1.75f));
    }

    public void m_8119_() {
        super.m_8119_();
        this.setLifespan(this.getLifespan() + 1);
        int adjustedLifespan = this.getLifespan() - this.getDelay();
        if (this.m_9236_().f_46443_) {
            if (adjustedLifespan == 2) {
                this.m_9236_().m_7106_((ParticleOptions)new RingParticle.RingData(0.0f, 1.5707964f, 20, 0.3882353f, 0.7607843f, 0.7882353f, 1.0f, this.getSize() * 6.0f, false, RingParticle.EnumRingBehavior.SHRINK), this.m_20185_(), this.m_20186_() + (double)0.3f, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            for (int i = 11; i < 30; i += 2) {
                if (adjustedLifespan != i) continue;
                this.smolder(1);
            }
            if (adjustedLifespan == 10) {
                if (!this.m_20067_()) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.EMP_ACTIVATED.get(), this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f, false);
                }
                double d0 = this.m_20185_();
                double d1 = this.m_20186_() + (double)this.getSize() + 0.03;
                double d2 = this.m_20189_();
                this.m_9236_().m_7107_((ParticleOptions)new LightningStormParticle.StormData(this.getSize()), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        } else {
            if (adjustedLifespan == 11 || adjustedLifespan == 12 || adjustedLifespan == 13 || adjustedLifespan == 14) {
                this.damageEntityLivingBaseNearby(0.1);
            }
            if (adjustedLifespan > 20) {
                this.m_146870_();
            }
        }
    }

    public void damageEntityLivingBaseNearby(double radius) {
        AABB aabb = this.m_20191_().m_82400_(radius);
        AABB selection = new AABB(aabb.f_82288_, this.m_20186_() - 0.1, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
        for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, selection)) {
            this.damage(livingentity);
        }
    }

    private void damage(LivingEntity Hitentity) {
        LivingEntity livingentity = this.getCaster();
        if (Hitentity.m_6084_() && !Hitentity.m_20147_() && Hitentity != livingentity) {
            if (livingentity == null) {
                Hitentity.m_6469_(this.m_269291_().m_269425_(), this.getDamage());
            } else {
                if (livingentity.m_7307_((Entity)Hitentity)) {
                    return;
                }
                Hitentity.m_6469_(CMDamageTypes.causeLightningDamage(this, (Entity)livingentity), this.getDamage() + Hitentity.m_21233_() * this.getHpDamage());
            }
        }
    }

    public void m_7822_(byte p_36935_) {
        super.m_7822_(p_36935_);
    }

    private void smolder(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 0.25f * this.getSize();
            float yaw = (float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI);
            float r = this.f_19796_.m_188501_() * 0.7f;
            float x = r * Mth.m_14089_((float)yaw);
            float z = r * Mth.m_14031_((float)yaw);
            float motionY = this.f_19796_.m_188501_() * 0.8f;
            float motionX = velocity * Mth.m_14089_((float)yaw);
            float motionZ = velocity * Mth.m_14031_((float)yaw);
            this.m_9236_().m_7106_((ParticleOptions)new LightningParticle.OrbData(99, 194, 201), this.m_20185_() + (double)x, this.m_20186_() + 0.1, this.m_20189_() + (double)z, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("lifespan", this.getLifespan());
        compound.m_128405_("delay", this.getDelay());
        if (this.ownerUUID != null) {
            compound.m_128362_("Owner", this.ownerUUID);
        }
        compound.m_128350_("damage", this.getDamage());
        compound.m_128350_("Hpdamage", this.getHpDamage());
        compound.m_128350_("size", this.getSize());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLifespan(compound.m_128451_("lifespan"));
        this.setDelay(compound.m_128451_("delay"));
        if (compound.m_128403_("Owner")) {
            this.ownerUUID = compound.m_128342_("Owner");
        }
        this.setDamage(compound.m_128457_("damage"));
        this.setHpDamage(compound.m_128457_("Hpdamage"));
        this.setSize(compound.m_128457_("size"));
    }
}

