/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.connectivity.logging.PacketLogging;
import java.nio.channels.ClosedChannelException;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.Packet;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Connection.class}, priority=5)
public abstract class AdvancedPacketErrorLogging {
    @Shadow
    protected abstract void m_129520_(Packet<?> var1, @Nullable PacketSendListener var2);

    @Redirect(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;sendPacket(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"), require=0)
    private void connectivity$logErrorFor(Connection instance, Packet<?> packet, PacketSendListener listener) {
        this.connectivity$wrapSend(packet, listener);
    }

    @Redirect(method={"flushQueue"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;sendPacket(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"), require=0)
    private void connectivity$logErrorForFlush(Connection instance, Packet<?> packet, PacketSendListener listener) {
        this.connectivity$wrapSend(packet, listener);
    }

    @Unique
    private void connectivity$wrapSend(Packet<?> packet, PacketSendListener listener) {
        try {
            this.m_129520_(packet, listener);
        }
        catch (Throwable t) {
            if (!(t instanceof ClosedChannelException) && ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                PacketLogging.logPacket(packet, "threw an error:" + t.getLocalizedMessage());
            }
            throw t;
        }
    }
}

