/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util;

import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animatable.instance.InstancedAnimatableInstanceCache;
import mod.azure.azurelib.core.animatable.instance.SingletonAnimatableInstanceCache;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.EasingType;
import mod.azure.azurelib.entities.TickingLightEntity;
import mod.azure.azurelib.items.AzureBaseGunItem;
import mod.azure.azurelib.loading.object.BakedModelFactory;
import mod.azure.azurelib.network.SerializableDataTicket;
import mod.azure.azurelib.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class AzureLibUtil {
    public static AnimatableInstanceCache createInstanceCache(GeoAnimatable animatable) {
        AnimatableInstanceCache cache = animatable.animatableCacheOverride();
        return cache != null ? cache : AzureLibUtil.createInstanceCache(animatable, !(animatable instanceof Entity) && !(animatable instanceof BlockEntity));
    }

    public static AnimatableInstanceCache createInstanceCache(GeoAnimatable animatable, boolean singletonObject) {
        AnimatableInstanceCache cache = animatable.animatableCacheOverride();
        if (cache != null) {
            return cache;
        }
        return singletonObject ? new SingletonAnimatableInstanceCache(animatable) : new InstancedAnimatableInstanceCache(animatable);
    }

    public static synchronized Animation.LoopType addCustomLoopType(String name, Animation.LoopType loopType) {
        return Animation.LoopType.register(name, loopType);
    }

    public static synchronized EasingType addCustomEasingType(String name, EasingType easingType) {
        return EasingType.register(name, easingType);
    }

    public static synchronized void addCustomBakedModelFactory(String namespace, BakedModelFactory factory) {
        BakedModelFactory.register(namespace, factory);
    }

    public static synchronized <D> SerializableDataTicket<D> addDataTicket(SerializableDataTicket<D> dataTicket) {
        return DataTickets.registerSerializable(dataTicket);
    }

    public static void summonAoE(LivingEntity entity, ParticleOptions particle, int yOffset, int duration, float radius, boolean hasEffect, @Nullable MobEffect effect, int effectTime) {
        AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(entity.m_9236_(), entity.m_20185_(), entity.m_20186_() + (double)yOffset, entity.m_20189_());
        areaEffectCloudEntity.m_19712_(radius);
        areaEffectCloudEntity.m_19734_(duration);
        areaEffectCloudEntity.m_19724_(particle);
        areaEffectCloudEntity.m_19738_(-areaEffectCloudEntity.m_19743_() / (float)areaEffectCloudEntity.m_19748_());
        if (hasEffect && !entity.m_21023_(effect)) {
            areaEffectCloudEntity.m_19716_(new MobEffectInstance(effect, effectTime, 0));
        }
        entity.m_9236_().m_7967_((Entity)areaEffectCloudEntity);
    }

    public static void removeAmmo(Item ammo, Player playerEntity) {
        if (playerEntity.m_21120_(playerEntity.m_7655_()).m_41720_() instanceof AzureBaseGunItem && !playerEntity.m_7500_()) {
            block0: for (ItemStack item : playerEntity.m_150109_().f_35976_) {
                if (item.m_41720_() == ammo) {
                    item.m_41774_(1);
                    break;
                }
                for (ItemStack item1 : playerEntity.m_150109_().f_35974_) {
                    if (item1.m_41720_() != ammo) continue;
                    item1.m_41774_(1);
                    continue block0;
                }
            }
        }
    }

    public static void spawnLightSource(Entity entity, boolean isInWaterBlock) {
        BlockEntity blockEntity;
        BlockPos lightBlockPos = null;
        if (lightBlockPos == null) {
            lightBlockPos = AzureLibUtil.findFreeSpace(entity.m_9236_(), entity.m_20183_());
            if (lightBlockPos == null) {
                return;
            }
            entity.m_9236_().m_46597_(lightBlockPos, Services.PLATFORM.getTickingLightBlock().m_49966_());
        } else if (AzureLibUtil.checkDistance(lightBlockPos, entity.m_20183_()) && (blockEntity = entity.m_9236_().m_7702_(lightBlockPos)) instanceof TickingLightEntity) {
            TickingLightEntity tickingLightEntity = (TickingLightEntity)blockEntity;
            tickingLightEntity.refresh(isInWaterBlock ? 20 : 0);
        }
    }

    private static boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= 2 && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= 2 && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= 2;
    }

    private static BlockPos findFreeSpace(Level world, BlockPos blockPos) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[5];
        offsets[0] = 0;
        for (int i = 2; i <= 4; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_7918_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals((Object)Services.PLATFORM.getTickingLightBlock())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }
}

