/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.block.LightableBlock;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.fan.FeatherFanFallCapability;
import twilightforest.init.TFSounds;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;
import twilightforest.util.WorldUtil;

public class PeacockFanItem
extends Item {
    public PeacockFanItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @Nonnull InteractionHand hand) {
        boolean flag;
        ItemStack stack = player.m_21120_(hand);
        boolean bl = flag = !player.m_20096_() && !player.m_6069_() && player.getCapability(CapabilityList.FEATHER_FAN_FALLING).map(FeatherFanFallCapability::getFalling).orElse(true) == false;
        if (!level.m_5776_()) {
            int fanned = this.doFan(level, player);
            stack.m_41622_(fanned + 1, (LivingEntity)player, user -> user.m_21190_(hand));
            if (flag) {
                player.getCapability(CapabilityList.FEATHER_FAN_FALLING).ifPresent(cap -> cap.setFalling(true));
            }
        } else {
            if (player.m_21255_()) {
                Vec3 look = player.m_20154_();
                Vec3 movement = player.m_20184_();
                player.m_20256_(movement.m_82520_(look.m_7096_() * 0.1 + (look.m_7096_() * 2.0 - movement.m_7096_()) * 0.5, look.m_7098_() * 0.1 + (look.m_7098_() * 2.0 - movement.m_7098_()) * 0.5 + 1.25, look.m_7094_() * 0.1 + (look.m_7094_() * 2.0 - movement.m_7094_()) * 0.5));
            }
            if (flag) {
                player.m_20256_(new Vec3(player.m_20184_().m_7096_() * (double)1.05f, 1.5, player.m_20184_().m_7094_() * (double)1.05f));
            } else {
                AABB fanBox = this.getEffectAABB(player);
                Vec3 lookVec = player.m_20154_();
                for (int i = 0; i < 30; ++i) {
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, fanBox.f_82288_ + (double)level.m_213780_().m_188501_() * (fanBox.f_82291_ - fanBox.f_82288_), fanBox.f_82289_ + (double)level.m_213780_().m_188501_() * (fanBox.f_82292_ - fanBox.f_82289_), fanBox.f_82290_ + (double)level.m_213780_().m_188501_() * (fanBox.f_82293_ - fanBox.f_82290_), lookVec.m_7096_(), lookVec.m_7098_(), lookVec.m_7094_());
                }
            }
            player.m_5496_((SoundEvent)TFSounds.FAN_WHOOSH.get(), 1.0f + level.m_213780_().m_188501_(), level.m_213780_().m_188501_() * 0.7f + 0.3f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack stack) {
        return 20;
    }

    private int doFan(Level level, Player player) {
        AABB fanBox = this.getEffectAABB(player);
        return this.fanBlocksInAABB(level, fanBox, player) + this.fanEntitiesInAABB(level, player, fanBox);
    }

    private int fanEntitiesInAABB(Level level, Player player, AABB fanBox) {
        Vec3 moveVec = player.m_20154_().m_82490_(2.0);
        Item fan = player.m_21211_().m_41720_();
        int fannedEntities = 0;
        for (Entity entity : level.m_45976_(Entity.class, fanBox)) {
            ServerPlayer pushedPlayer;
            if (entity.m_6094_() || entity instanceof ItemEntity || entity instanceof Projectile) {
                entity.m_20334_(moveVec.m_7096_(), moveVec.m_7098_(), moveVec.m_7094_());
                ++fannedEntities;
            }
            if (!(entity instanceof ServerPlayer) || (pushedPlayer = (ServerPlayer)entity) == player || pushedPlayer.m_6144_()) continue;
            TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> pushedPlayer), (Object)new ThrowPlayerPacket(moveVec.m_7096_(), moveVec.m_7098_(), moveVec.m_7094_()));
            player.m_36335_().m_41524_(fan, 40);
            fannedEntities += 2;
        }
        return fannedEntities;
    }

    private AABB getEffectAABB(Player player) {
        double range = 3.0;
        double radius = 2.0;
        Vec3 srcVec = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        Vec3 lookVec = player.m_20154_().m_82490_(range);
        Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_(), lookVec.m_7098_(), lookVec.m_7094_());
        return new AABB(destVec.m_7096_() - radius, destVec.m_7098_() - radius, destVec.m_7094_() - radius, destVec.m_7096_() + radius, destVec.m_7098_() + radius, destVec.m_7094_() + radius);
    }

    private int fanBlocksInAABB(Level level, AABB box, Player player) {
        int fan = 0;
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            fan += this.fanBlock(level, pos, player);
        }
        return fan;
    }

    private int fanBlock(Level level, BlockPos pos, Player player) {
        int cost = 0;
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof FlowerBlock) {
            if (level.m_213780_().m_188503_(3) == 0 && !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, state, player))) {
                level.m_46961_(pos, true);
                ++cost;
            }
        } else if (state.m_60734_() instanceof AbstractCandleBlock && ((Boolean)state.m_61143_((Property)AbstractCandleBlock.f_151895_)).booleanValue()) {
            AbstractCandleBlock.m_151899_(null, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
        } else {
            Block block = state.m_60734_();
            if (block instanceof LightableBlock) {
                LightableBlock lightable = (LightableBlock)block;
                if (state.m_61143_(LightableBlock.LIGHTING) != LightableBlock.Lighting.NONE) {
                    lightable.extinguish(null, state, (LevelAccessor)level, pos);
                }
            }
        }
        return cost;
    }
}

