/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.ArrayUtils;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.entity.boss.Lich;

public class ShieldLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public static final ModelResourceLocation LOC = new ModelResourceLocation(new ResourceLocation("twilightforest", "shield"), "inventory");
    private static final Direction[] DIRS = (Direction[])ArrayUtils.add((Object[])Direction.values(), null);

    public ShieldLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    private int getShieldCount(T entity) {
        return entity instanceof Lich ? ((Lich)entity).getShieldStrength() : entity.getCapability(CapabilityList.SHIELDS).map(IShieldCapability::shieldsLeft).orElse(0).intValue();
    }

    private void renderShields(PoseStack stack, MultiBufferSource buffer, T entity, float partialTicks) {
        float age = (float)((LivingEntity)entity).f_19797_ + partialTicks;
        float rotateAngleY = age / 5.0f;
        float rotateAngleX = Mth.m_14031_((float)(age / 5.0f)) / 4.0f;
        float rotateAngleZ = Mth.m_14089_((float)(age / 5.0f)) / 4.0f;
        int count = this.getShieldCount(entity);
        for (int c = 0; c < count; ++c) {
            stack.m_85836_();
            stack.m_85837_(-0.5, 0.5, -0.5);
            stack.m_85841_(1.0f, -1.0f, 1.0f);
            stack.m_85837_(0.5, 0.5, 0.5);
            stack.m_252781_(Axis.f_252403_.m_252977_(rotateAngleZ * 57.295776f));
            stack.m_252781_(Axis.f_252436_.m_252977_(rotateAngleY * 57.295776f + (float)c * (360.0f / (float)count)));
            stack.m_252781_(Axis.f_252529_.m_252977_(rotateAngleX * 57.295776f));
            stack.m_85837_(-0.5, -0.5, -0.5);
            stack.m_252880_(0.0f, 0.0f, -0.7f);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(LOC);
            for (Direction dir : DIRS) {
                Minecraft.m_91087_().m_91291_().m_115162_(stack, buffer.m_6299_(Sheets.m_110792_()), model.getQuads(null, dir, entity.m_217043_(), ModelData.EMPTY, Sheets.m_110792_()), ItemStack.f_41583_, 0xF000F0, OverlayTexture.f_118083_);
            }
            stack.m_85849_();
        }
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.getShieldCount(living) > 0) {
            this.renderShields(stack, buffer, living, partialTicks);
        }
    }
}

