/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import twilightforest.TwilightForestMod;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.BlockChainGoblinModel;
import twilightforest.client.model.entity.ChainModel;
import twilightforest.client.model.entity.SpikeBlockModel;
import twilightforest.client.renderer.entity.BlockChainRenderer;
import twilightforest.entity.monster.BlockChainGoblin;

public class BlockChainGoblinRenderer<T extends BlockChainGoblin, M extends BlockChainGoblinModel<T>>
extends HumanoidMobRenderer<T, M> {
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("blockgoblin.png");
    private final Model model;
    private final Model chainModel;

    public BlockChainGoblinRenderer(EntityRendererProvider.Context manager, M goblinModel, float shadowSize) {
        super(manager, goblinModel, shadowSize);
        this.model = new SpikeBlockModel(manager.m_174023_(TFModelLayers.CHAIN_BLOCK));
        this.chainModel = new ChainModel(manager.m_174023_(TFModelLayers.CHAIN));
    }

    public void render(T goblin, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        super.m_7392_(goblin, yaw, partialTicks, stack, buffer, light);
        stack.m_85836_();
        double blockInX = ((BlockChainGoblin)((Object)goblin)).block.m_20185_() - goblin.m_20185_();
        double blockInY = ((BlockChainGoblin)((Object)goblin)).block.m_20186_() - goblin.m_20186_();
        double blockInZ = ((BlockChainGoblin)((Object)goblin)).block.m_20189_() - goblin.m_20189_();
        VertexConsumer ivertexbuilder = buffer.m_6299_(this.model.m_103119_(textureLoc));
        stack.m_85837_(blockInX, blockInY, blockInZ);
        float pitch = ((BlockChainGoblin)((Object)goblin)).f_19860_ + (goblin.m_146909_() - ((BlockChainGoblin)((Object)goblin)).f_19860_) * partialTicks;
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f - Mth.m_14177_((float)yaw)));
        stack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        stack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.m_7695_(stack, ivertexbuilder, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
        BlockChainRenderer.renderChain(goblin, (Entity)((BlockChainGoblin)((Object)goblin)).chain1, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain(goblin, (Entity)((BlockChainGoblin)((Object)goblin)).chain2, yaw, partialTicks, stack, buffer, light, this.chainModel);
        BlockChainRenderer.renderChain(goblin, (Entity)((BlockChainGoblin)((Object)goblin)).chain3, yaw, partialTicks, stack, buffer, light, this.chainModel);
        if (this.f_114476_.m_114377_() && !((BlockChainGoblin)((Object)goblin)).block.m_20145_() && !Minecraft.m_91087_().m_91299_()) {
            stack.m_85836_();
            stack.m_85837_(blockInX, blockInY, blockInZ);
            this.renderMultiBoundingBox(stack, buffer.m_6299_(RenderType.m_110504_()), (Entity)((BlockChainGoblin)((Object)goblin)).block, 0.25f, 1.0f, 0.0f);
            stack.m_85849_();
        }
    }

    private void renderMultiBoundingBox(PoseStack stack, VertexConsumer builder, Entity entity, float red, float grean, float blue) {
        AABB axisalignedbb = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
        LevelRenderer.m_109646_((PoseStack)stack, (VertexConsumer)builder, (AABB)axisalignedbb, (float)red, (float)grean, (float)blue, (float)1.0f);
    }

    public boolean shouldRender(T entity, Frustum clippingHelper, double camX, double camY, double camZ) {
        if (super.m_5523_(entity, clippingHelper, camX, camY, camZ)) {
            return true;
        }
        Vec3 vec3d = this.getPosition((Entity)((BlockChainGoblin)((Object)entity)).block, (double)((BlockChainGoblin)((Object)entity)).block.m_20206_() * 0.5, 1.0f);
        Vec3 vec3d1 = this.getPosition((Entity)((BlockChainGoblin)((Object)entity)).block, ((BlockChainGoblin)((Object)entity)).block.m_20192_(), 1.0f);
        return clippingHelper.m_113029_(new AABB(vec3d1.f_82479_, vec3d1.f_82480_, vec3d1.f_82481_, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_));
    }

    private Vec3 getPosition(Entity entity, double p_177110_2_, float p_177110_4_) {
        double d0 = Mth.m_14139_((double)p_177110_4_, (double)entity.f_19790_, (double)entity.m_20185_());
        double d1 = Mth.m_14139_((double)p_177110_4_, (double)entity.f_19791_, (double)entity.m_20186_()) + p_177110_2_;
        double d2 = Mth.m_14139_((double)p_177110_4_, (double)entity.f_19792_, (double)entity.m_20189_());
        return new Vec3(d0, d1, d2);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return textureLoc;
    }
}

