/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;

public class TFShaders {
    public static ShaderInstance RED_THREAD;
    public static PositionAwareShaderInstance AURORA;

    public static void init(IEventBus bus) {
        bus.addListener(event -> {
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), TwilightForestMod.prefix("red_thread/red_thread"), DefaultVertexFormat.f_85811_), shader -> {
                    RED_THREAD = shader;
                });
                event.registerShader((ShaderInstance)new PositionAwareShaderInstance(event.getResourceProvider(), TwilightForestMod.prefix("aurora/aurora"), DefaultVertexFormat.f_85815_), shader -> {
                    AURORA = (PositionAwareShaderInstance)((Object)((Object)shader));
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static class PositionAwareShaderInstance
    extends BindableShaderInstance {
        @Nullable
        public final Uniform SEED = this.m_173348_("SeedContext");
        @Nullable
        public final Uniform POSITION = this.m_173348_("PositionContext");

        public PositionAwareShaderInstance(ResourceProvider p_173336_, ResourceLocation shaderLocation, VertexFormat p_173338_) throws IOException {
            super(p_173336_, shaderLocation, p_173338_);
        }

        public final void setValue(int seed, float x, float y, float z) {
            if (this.SEED != null) {
                this.SEED.m_142617_(seed);
            }
            if (this.POSITION != null) {
                this.POSITION.m_5889_(x, y, z);
            }
        }

        public final void setValueBindApply(int seed, float x, float y, float z) {
            this.bind(() -> this.setValue(seed, x, y, z));
        }

        public final void reset() {
            this.setValue(0, 0.0f, 0.0f, 0.0f);
        }

        public final void resetClear() {
            this.runThenClear(this::reset);
        }

        public final void invokeThenClear(int seed, float x, float y, float z, Runnable exec) {
            this.setValueBindApply(seed, x, y, z);
            exec.run();
            this.resetClear();
        }

        public final void invokeThenEndTesselator(int seed, float x, float y, float z) {
            this.invokeThenClear(seed, x, y, z, () -> Tesselator.m_85913_().m_85914_());
        }
    }

    public static class BindableShaderInstance
    extends ShaderInstance {
        private ShaderInstance last;

        public BindableShaderInstance(ResourceProvider p_173336_, ResourceLocation shaderLocation, VertexFormat p_173338_) throws IOException {
            super(p_173336_, shaderLocation, p_173338_);
        }

        ShaderInstance getSelf() {
            return this;
        }

        public final void bind(@Nullable Runnable exec) {
            this.last = RenderSystem.getShader();
            RenderSystem.setShader(this::getSelf);
            if (exec != null) {
                exec.run();
            }
            this.m_173363_();
        }

        public final void runThenClear(Runnable exec) {
            exec.run();
            this.m_173362_();
            RenderSystem.setShader(() -> this.last);
            this.last = null;
        }

        public final void invokeThenClear(@Nullable Runnable execBind, Runnable execPost) {
            this.bind(execBind);
            this.runThenClear(execPost);
        }

        public final void invokeThenClear(Runnable execPost) {
            this.invokeThenClear(null, execPost);
        }

        public final void invokeThenEndTesselator(@Nullable Runnable execBind) {
            this.invokeThenClear(execBind, () -> Tesselator.m_85913_().m_85914_());
        }

        public final void invokeThenEndTesselator() {
            this.invokeThenClear(() -> Tesselator.m_85913_().m_85914_());
        }
    }
}

