/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.mixin;

import com.cak.pattern_schematics.content.item.PatternSchematicItem;
import com.cak.pattern_schematics.foundation.mirror.PatternSchematicWorld;
import com.cak.pattern_schematics.foundation.util.Vec3iUtils;
import com.simibubi.create.content.schematics.SchematicPrinter;
import com.simibubi.create.content.schematics.SchematicWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SchematicPrinter.class}, remap=false)
public class SchematicPrinterMixin {
    private static ItemStack lastThreadStack = null;
    private static StructureTemplate lastThreadStructureTemplate = null;
    @Shadow
    private SchematicWorld blockReader;
    ServerLevelAccessor lastWorld;
    StructurePlaceSettings lastPlaceSettings;

    @Inject(method={"loadSchematic"}, at={@At(value="HEAD")})
    private void loadSchematic_head(ItemStack blueprint, Level originalWorld, boolean processNBT, CallbackInfo ci) {
        lastThreadStack = blueprint;
    }

    @ModifyVariable(method={"loadSchematic"}, ordinal=0, at=@At(value="STORE"))
    private StructureTemplate store_activeTemplate(StructureTemplate template) {
        lastThreadStructureTemplate = template;
        return template;
    }

    @Inject(method={"loadSchematic"}, at={@At(value="FIELD", shift=At.Shift.AFTER, opcode=181, target="Lcom/simibubi/create/content/schematics/SchematicPrinter;blockReader:Lcom/simibubi/create/content/schematics/SchematicWorld;")})
    private void loadSchematic(ItemStack blueprint, Level originalWorld, boolean processNBT, CallbackInfo ci) {
        if (lastThreadStack.m_41720_() instanceof PatternSchematicItem) {
            PatternSchematicWorld patternSchematicWorld = new PatternSchematicWorld(this.blockReader.anchor, (Level)this.blockReader.m_6018_());
            patternSchematicWorld.putExtraData(blueprint, lastThreadStructureTemplate);
            this.blockReader = patternSchematicWorld;
        }
    }

    @Redirect(method={"loadSchematic"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;placeInWorld(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Lnet/minecraft/util/RandomSource;I)Z", remap=true))
    private boolean loadSchem(StructureTemplate instance, ServerLevelAccessor world, BlockPos blockPos1, BlockPos blockPos2, StructurePlaceSettings placeSettings, RandomSource randomSource, int i) {
        this.lastWorld = world;
        this.lastPlaceSettings = placeSettings;
        if (world instanceof PatternSchematicWorld) {
            PatternSchematicWorld patternSchematicWorld = (PatternSchematicWorld)world;
            Vec3i minScale = patternSchematicWorld.cloneScaleMin;
            Vec3i maxScale = patternSchematicWorld.cloneScaleMax;
            BlockPos scale1 = new BlockPos(minScale).m_7954_(placeSettings.m_74404_());
            BlockPos scale2 = new BlockPos(maxScale).m_7954_(placeSettings.m_74404_());
            minScale = Vec3iUtils.min((Vec3i)scale1, (Vec3i)scale2);
            maxScale = Vec3iUtils.max((Vec3i)scale1, (Vec3i)scale2);
            for (int x = minScale.m_123341_(); x <= maxScale.m_123341_(); ++x) {
                for (int y = minScale.m_123342_(); y <= maxScale.m_123342_(); ++y) {
                    for (int z = minScale.m_123343_(); z <= maxScale.m_123343_(); ++z) {
                        BlockPos anchor = blockPos1.m_121955_(Vec3iUtils.multiplyVec3i(new Vec3i(x, y, z), patternSchematicWorld.sourceBounds.m_71053_().m_7918_(1, 1, 1)));
                        instance.m_230328_(world, anchor, anchor, placeSettings, randomSource, i);
                    }
                }
            }
            return true;
        }
        return instance.m_230328_(world, blockPos1, blockPos2, placeSettings, randomSource, i);
    }

    @Redirect(method={"loadSchematic"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/foundation/utility/BBHelper;encapsulate(Lnet/minecraft/world/level/levelgen/structure/BoundingBox;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/levelgen/structure/BoundingBox;", remap=true))
    private BoundingBox loadSchem(BoundingBox bb, BlockPos pos) {
        ServerLevelAccessor serverLevelAccessor = this.lastWorld;
        if (serverLevelAccessor instanceof PatternSchematicWorld) {
            PatternSchematicWorld patternSchematicWorld = (PatternSchematicWorld)serverLevelAccessor;
            return patternSchematicWorld.genBounds(bb, this.lastPlaceSettings);
        }
        return bb;
    }
}

