/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.mixin;

import com.cak.pattern_schematics.foundation.mixin_accessors.MovementContextAccessor;
import com.cak.pattern_schematics.registry.PatternSchematicsRegistry;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.kinetics.deployer.DeployerBlock;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.MutablePair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContraptionEntity.class}, remap=false)
public class AbstractContraptionEntityMixin {
    @Shadow
    protected Contraption contraption;

    @Inject(method={"handlePlayerInteraction"}, at={@At(value="HEAD")}, cancellable=true)
    public void handlePlayerInteraction(Player player, BlockPos localPos, Direction side, InteractionHand interactionHand, CallbackInfoReturnable<Boolean> cir) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (player.m_9236_().f_46443_ || !player.m_6144_() || !stack.m_150930_((Item)PatternSchematicsRegistry.PATTERN_SCHEMATIC.get())) {
            return;
        }
        if (!stack.m_41782_() || !stack.m_41784_().m_128471_("Deployed")) {
            player.m_5661_((Component)Component.m_237115_((String)"create_pattern_schematics.contraption_application.not_positioned").m_130940_(ChatFormatting.RED), true);
            cir.setReturnValue((Object)true);
            return;
        }
        MutablePair actor = this.contraption.getActorAt(localPos);
        if (actor == null || !((StructureTemplate.StructureBlockInfo)actor.getLeft()).f_74676_().m_60713_((Block)AllBlocks.DEPLOYER.get())) {
            return;
        }
        int appliedCount = this.pattern_schematics$performBulkSchematicApply((Direction)((StructureTemplate.StructureBlockInfo)actor.getLeft()).f_74676_().m_61143_((Property)DeployerBlock.FACING), ((MovementContext)actor.getRight()).localPos, stack);
        player.m_5661_((Component)Component.m_237115_((String)"create_pattern_schematics.contraption_application.applied_to").m_7220_((Component)Component.m_237113_((String)String.valueOf(appliedCount))).m_7220_((Component)Component.m_237115_((String)"create_pattern_schematics.contraption_application.deployers")), true);
        cir.setReturnValue((Object)true);
    }

    @Unique
    private int pattern_schematics$performBulkSchematicApply(Direction facingDirection, BlockPos localPos, ItemStack item) {
        Set<MovementContext> deployerActors = this.pattern_schematics$collectDeployerSurface(facingDirection, localPos);
        FilterItemStack newFilter = FilterItemStack.of((ItemStack)item);
        CompoundTag newFilterTag = newFilter.serializeNBT();
        for (MovementContext context : deployerActors) {
            context.blockEntityData.m_128365_("Filter", (Tag)newFilterTag.m_6426_());
            ((MovementContextAccessor)context).pattern_schematics$setFilter(newFilter);
        }
        return deployerActors.size();
    }

    @Unique
    private Set<MovementContext> pattern_schematics$collectDeployerSurface(Direction facingDirection, BlockPos localPos) {
        Set<MovementContext> allDeployers = this.contraption.getActors().stream().filter(actor -> ((StructureTemplate.StructureBlockInfo)actor.getLeft()).f_74676_().m_60713_((Block)AllBlocks.DEPLOYER.get()) && ((StructureTemplate.StructureBlockInfo)actor.getLeft()).f_74676_().m_61143_((Property)DeployerBlock.FACING) == facingDirection).map(MutablePair::getRight).collect(Collectors.toSet());
        return this.pattern_schematics$getConnectedDeployers(facingDirection, localPos, allDeployers);
    }

    @Unique
    private Set<MovementContext> pattern_schematics$getConnectedDeployers(Direction facingDirection, BlockPos localPos, Set<MovementContext> allDeployers) {
        HashMap<BlockPos, MovementContext> deployerPositions = new HashMap<BlockPos, MovementContext>();
        allDeployers.forEach(context -> deployerPositions.put(context.localPos, (MovementContext)context));
        HashSet<BlockPos> frontier = new HashSet<BlockPos>();
        this.pattern_schematics$searchForConnected(this.pattern_schematics$getSearchDirections(facingDirection), localPos, deployerPositions, frontier);
        HashSet<MovementContext> validDeployers = new HashSet<MovementContext>();
        for (BlockPos pos : frontier) {
            validDeployers.add(deployerPositions.get(pos));
        }
        return validDeployers;
    }

    @Unique
    private void pattern_schematics$searchForConnected(Set<Direction> directions, BlockPos currentPos, HashMap<BlockPos, MovementContext> deployerPositions, Set<BlockPos> frontier) {
        if (frontier.contains(currentPos) || !deployerPositions.containsKey(currentPos) || frontier.size() > 512) {
            return;
        }
        frontier.add(currentPos);
        for (Direction direction : directions) {
            this.pattern_schematics$searchForConnected(directions, currentPos.m_121955_(direction.m_122436_()), deployerPositions, frontier);
        }
    }

    @Unique
    private Set<Direction> pattern_schematics$getSearchDirections(Direction facingDirection) {
        return Arrays.stream(Direction.values()).filter(direction -> direction.m_122434_() != facingDirection.m_122434_()).collect(Collectors.toSet());
    }
}

