/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.cak.pattern_schematics.PatternSchematics;
import com.cak.pattern_schematics.foundation.mirror.PatternSchematicsToolType;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PatternSchematicsToolSelectionScreen
extends Screen {
    public final String scrollToCycle = Lang.translateDirect((String)"gui.toolmenu.cycle", (Object[])new Object[0]).getString();
    public final String holdToFocus = "gui.toolmenu.focusKey";
    protected List<PatternSchematicsToolType> tools;
    protected Consumer<PatternSchematicsToolType> callback;
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;
    protected int w;
    protected int h;

    public PatternSchematicsToolSelectionScreen(List<PatternSchematicsToolType> tools, Consumer<PatternSchematicsToolType> callback) {
        super((Component)Components.literal((String)"Tool Selection"));
        this.f_96541_ = Minecraft.m_91087_();
        this.tools = tools;
        this.callback = callback;
        this.focused = false;
        this.yOffset = 0.0f;
        this.selection = 0;
        this.initialized = false;
        callback.accept(tools.get(this.selection));
        this.w = Math.max(tools.size() * 50 + 30, 220);
        this.h = 30;
    }

    public void setSelectedElement(PatternSchematicsToolType tool) {
        if (!this.tools.contains((Object)tool)) {
            return;
        }
        this.selection = this.tools.indexOf((Object)tool);
    }

    public void cycle(int direction) {
        this.selection += direction < 0 ? 1 : -1;
        this.selection = (this.selection + this.tools.size()) % this.tools.size();
    }

    private void draw(GuiGraphics graphics, float partialTicks) {
        PoseStack matrixStack = graphics.m_280168_();
        Window mainWindow = this.f_96541_.m_91268_();
        if (!this.initialized) {
            this.m_6575_(this.f_96541_, mainWindow.m_85445_(), mainWindow.m_85446_());
        }
        int x = (mainWindow.m_85445_() - this.w) / 2 + 15;
        int y = mainWindow.m_85446_() - this.h - 75;
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, -this.yOffset, this.focused ? 100.0f : 0.0f);
        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;
        ResourceLocation patternSchematicsGray = PatternSchematics.asResource(gray.location.m_135815_());
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.focused ? 0.875f : 0.5f));
        graphics.m_280163_(patternSchematicsGray, x - 15, y, (float)gray.startX, (float)gray.startY, this.w, this.h, gray.width, gray.height);
        float toolTipAlpha = this.yOffset / 10.0f;
        List<Component> toolTip = this.tools.get(this.selection).getDescription();
        int stringAlphaComponent = (int)(toolTipAlpha * 255.0f) << 24;
        if (toolTipAlpha > 0.25f) {
            RenderSystem.setShaderColor((float)0.8f, (float)0.7f, (float)0.8f, (float)toolTipAlpha);
            graphics.m_280163_(patternSchematicsGray, x - 15, y + 33, (float)gray.startX, (float)gray.startY, this.w, this.h + 22, gray.width, gray.height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (toolTip.size() > 0) {
                graphics.m_280614_(this.f_96547_, toolTip.get(0), x - 10, y + 38, 0xEEEEEE + stringAlphaComponent, false);
            }
            if (toolTip.size() > 1) {
                graphics.m_280614_(this.f_96547_, toolTip.get(1), x - 10, y + 50, 0xEECDEE + stringAlphaComponent, false);
            }
            if (toolTip.size() > 2) {
                graphics.m_280614_(this.f_96547_, toolTip.get(2), x - 10, y + 60, 0xEECDEE + stringAlphaComponent, false);
            }
            if (toolTip.size() > 3) {
                graphics.m_280614_(this.f_96547_, toolTip.get(3), x - 10, y + 72, 0xDDCCDD + stringAlphaComponent, false);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.getBoundKey();
            int width = this.f_96541_.m_91268_().m_85445_();
            if (!this.focused) {
                graphics.m_280653_(this.f_96541_.f_91062_, (Component)Lang.translateDirect((String)"gui.toolmenu.focusKey", (Object[])new Object[]{keyName}), width / 2, y - 10, 0xEECDEE);
            } else {
                graphics.m_280137_(this.f_96541_.f_91062_, this.scrollToCycle, width / 2, y - 10, 0xEECDEE);
            }
        } else {
            x += 65;
        }
        for (int i = 0; i < this.tools.size(); ++i) {
            float alpha;
            RenderSystem.enableBlend();
            matrixStack.m_85836_();
            float f = alpha = this.focused ? 1.0f : 0.2f;
            if (i == this.selection) {
                matrixStack.m_252880_(0.0f, -10.0f, 0.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.m_280137_(this.f_96541_.f_91062_, this.tools.get(i).getDisplayName().getString(), x + i * 50 + 24, y + 28, 0xEECDEE);
                alpha = 1.0f;
            }
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
            this.tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 12);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            this.tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 11);
            matrixStack.m_85849_();
        }
        RenderSystem.disableBlend();
        matrixStack.m_85849_();
    }

    public void update() {
        this.yOffset = this.focused ? (this.yOffset += (10.0f - this.yOffset) * 0.1f) : (this.yOffset *= 0.9f);
    }

    public void renderPassive(GuiGraphics graphics, float partialTicks) {
        this.draw(graphics, partialTicks);
    }

    public void m_7379_() {
        this.callback.accept(this.tools.get(this.selection));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initialized = true;
    }
}

