/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation.mirror;

import com.cak.pattern_schematics.foundation.util.Vec3iUtils;
import com.simibubi.create.content.schematics.SchematicChunkSource;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.SchematicWorld;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;

public class PatternSchematicWorld
extends SchematicWorld {
    public Vec3i cloneScaleMin;
    public Vec3i cloneScaleMax;
    public Vec3i cloneOffset;
    public BoundingBox sourceBounds;

    public PatternSchematicWorld(BlockPos anchor, Level original) {
        super(anchor, original);
        this.setChunkSource((ChunkSource)new SchematicChunkSource((Level)this));
        this.blocks = new HashMap();
        this.blockEntities = new HashMap();
        this.bounds = new BoundingBox(BlockPos.f_121853_);
        this.anchor = anchor;
        this.entities = new ArrayList();
        this.renderedBlockEntities = new ArrayList();
    }

    public void putExtraData(ItemStack blueprint, StructureTemplate template) {
        CompoundTag tag = blueprint.m_41783_();
        assert (tag != null);
        this.cloneScaleMin = Vec3iUtils.getVec3i("CloneScaleMin", tag);
        this.cloneScaleMax = Vec3iUtils.getVec3i("CloneScaleMax", tag);
        this.cloneOffset = Vec3iUtils.getVec3i("CloneOffset", tag);
        this.sourceBounds = template.m_74633_(SchematicItem.getSettings((ItemStack)blueprint), this.anchor);
    }

    public boolean m_7967_(Entity entityIn) {
        return this.applyToClones(clonePos -> {
            Entity newEntity = this.cloneEntity(entityIn);
            newEntity.m_146884_(this.applyCloneToRealLoc(newEntity.m_20182_(), (Vec3i)clonePos));
            return super.m_7967_(newEntity);
        });
    }

    protected Entity cloneEntity(Entity source) {
        CompoundTag tag = new CompoundTag();
        source.m_20223_(tag);
        Entity newEntity = (Entity)EntityType.m_20642_((CompoundTag)tag, (Level)this.world).orElseThrow();
        newEntity.m_20084_(UUID.randomUUID());
        return newEntity;
    }

    protected boolean applyToClones(Function<Vec3i, Boolean> function) {
        AtomicBoolean result = new AtomicBoolean(false);
        this.forEachClone(clonePos -> {
            if (((Boolean)function.apply((Vec3i)clonePos)).booleanValue()) {
                result.set(true);
            }
        });
        return result.get();
    }

    protected void forEachClone(Consumer<Vec3i> consumer) {
        for (int x = this.cloneScaleMin.m_123341_(); x <= this.cloneScaleMax.m_123341_(); ++x) {
            for (int y = this.cloneScaleMin.m_123342_(); y <= this.cloneScaleMax.m_123342_(); ++y) {
                for (int z = this.cloneScaleMin.m_123343_(); z <= this.cloneScaleMax.m_123343_(); ++z) {
                    consumer.accept(new Vec3i(x, y, z));
                }
            }
        }
    }

    public BoundingBox genBounds(BoundingBox originalBounds, StructurePlaceSettings placeSettings) {
        return originalBounds;
    }

    protected Vec3 applyCloneToRealLoc(Vec3 local, Vec3i clone) {
        return local.m_82549_(Vec3.m_82528_((Vec3i)Vec3iUtils.multiplyVec3i(clone, this.sourceBounds.m_71053_().m_7918_(1, 1, 1))));
    }
}

