/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics.foundation;

import com.cak.pattern_schematics.content.item.PatternSchematicItem;
import com.cak.pattern_schematics.registry.PatternSchematicsRegistry;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.schematics.SchematicItem;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public enum SchematicUploadItemSource {
    DEFAULT(SchematicItem::create, 0, List.of(AllItems.EMPTY_SCHEMATIC, AllItems.SCHEMATIC_AND_QUILL, AllItems.SCHEMATIC)),
    PATTERN(PatternSchematicItem::create, 1, List.of(PatternSchematicsRegistry.EMPTY_PATTERN_SCHEMATIC, PatternSchematicsRegistry.PATTERN_SCHEMATIC));

    final SchematicItemFactory factory;
    final int nbtValue;
    final List<ItemEntry<? extends Item>> schematicSourceItem;

    private SchematicUploadItemSource(SchematicItemFactory factory, int nbtValue, List<ItemEntry<? extends Item>> schematicSourceItem) {
        this.factory = factory;
        this.nbtValue = nbtValue;
        this.schematicSourceItem = schematicSourceItem;
    }

    public SchematicItemFactory getFactory() {
        return this.factory;
    }

    public int getNbtValue() {
        return this.nbtValue;
    }

    public List<ItemEntry<? extends Item>> getSchematicSourceItems() {
        return this.schematicSourceItem;
    }

    public static SchematicUploadItemSource tryFromItemStack(ItemStack stack) {
        return Arrays.stream(SchematicUploadItemSource.values()).filter(source -> source.getSchematicSourceItems().stream().anyMatch(sourceItem -> sourceItem.isIn(stack))).findAny().orElse(null);
    }

    public static SchematicUploadItemSource tryFromInt(int nbtValue) {
        return Arrays.stream(SchematicUploadItemSource.values()).filter(source -> source.getNbtValue() == nbtValue).findAny().orElse(null);
    }

    public static interface SchematicItemFactory {
        public ItemStack create(HolderGetter<Block> var1, String var2, String var3);
    }
}

