/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.helper.MathUtils;
import nx.pingwheel.common.resource.ResourceReloadListener;

public class DrawContext {
    private static final int WHITE = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    private static final int SHADOW_BLACK = FastColor.ARGB32.m_13660_((int)64, (int)0, (int)0, (int)0);
    private GuiGraphics guiGraphics;
    private PoseStack matrices;

    public DrawContext(GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.matrices = guiGraphics.m_280168_();
    }

    public void renderLabel(Component text, float yOffset, PlayerInfo player) {
        int extraWidth = player != null ? 10 : 0;
        float f = ClientGlobal.Game.f_91062_.m_92852_((FormattedText)text) + extraWidth;
        Objects.requireNonNull(ClientGlobal.Game.f_91062_);
        Vec2 textMetrics = new Vec2(f, 9.0f);
        Vec2 textOffset = textMetrics.m_165903_(-0.5f).m_165910_(new Vec2(0.0f, textMetrics.f_82471_ * yOffset));
        this.matrices.m_85836_();
        this.matrices.m_252880_(textOffset.f_82470_, textOffset.f_82471_, 0.0f);
        this.guiGraphics.m_280509_(-2, -2, (int)textMetrics.f_82470_ + 1, (int)textMetrics.f_82471_, SHADOW_BLACK);
        this.guiGraphics.m_280614_(ClientGlobal.Game.f_91062_, text, extraWidth, 0, WHITE, false);
        if (player != null) {
            this.matrices.m_85837_(-0.5, -0.5, 0.0);
            this.renderPlayerHead(player);
        }
        this.matrices.m_85849_();
    }

    public void renderPlayerHead(PlayerInfo player) {
        ResourceLocation texture = player.m_105337_();
        RenderSystem.enableBlend();
        this.guiGraphics.m_280398_(texture, 0, 0, 0, 8.0f, 8.0f, 8, 8, 64, 64);
        this.guiGraphics.m_280398_(texture, 0, 0, 0, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
    }

    public void renderPing(ItemStack itemStack, boolean drawItemIcon) {
        if (itemStack != null && drawItemIcon) {
            this.renderGuiItemModel(itemStack);
        } else if (ResourceReloadListener.hasCustomTexture()) {
            this.renderTexture(ClientGlobal.PING_TEXTURE_ID, 12);
        } else {
            this.renderDefaultPingIcon();
        }
    }

    public void renderGuiItemModel(ItemStack itemStack) {
        this.guiGraphics.m_280064_(itemStack, -8, -8, 0, -150);
    }

    public void renderDefaultPingIcon() {
        this.matrices.m_85836_();
        MathUtils.rotateZ(this.matrices, 0.7853982f);
        this.matrices.m_85837_(-2.5, -2.5, 0.0);
        this.guiGraphics.m_280509_(0, 0, 5, 5, WHITE);
        this.matrices.m_85849_();
    }

    public void renderTexture(ResourceLocation texture, int size) {
        int offset = size / -2;
        RenderSystem.enableBlend();
        this.guiGraphics.m_280398_(texture, offset, offset, 0, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.disableBlend();
    }

    public void renderArrowIcon() {
        this.renderTexture(ClientGlobal.ARROW_TEXTURE_ID, 10);
    }
}

