/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.packet.custom;

import com.cerbon.better_beacons.BetterBeacons;
import com.cerbon.better_beacons.menu.custom.NewBeaconMenu;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class BeaconC2SPacket {
    private final Optional<MobEffect> primary;
    private final Optional<MobEffect> secondary;
    private final Optional<MobEffect> tertiary;

    public BeaconC2SPacket(Optional<MobEffect> primary, Optional<MobEffect> secondary, Optional<MobEffect> tertiary) {
        this.primary = primary;
        this.secondary = secondary;
        this.tertiary = tertiary;
    }

    public BeaconC2SPacket(FriendlyByteBuf buffer) {
        this.primary = buffer.m_236860_(effect -> (MobEffect)effect.m_236816_((IdMap)BuiltInRegistries.f_256974_));
        this.secondary = buffer.m_236860_(effect -> (MobEffect)effect.m_236816_((IdMap)BuiltInRegistries.f_256974_));
        this.tertiary = buffer.m_236860_(effect -> (MobEffect)effect.m_236816_((IdMap)BuiltInRegistries.f_256974_));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_236835_(this.primary, (buffer1, effect) -> buffer1.m_236818_((IdMap)BuiltInRegistries.f_256974_, effect));
        buffer.m_236835_(this.secondary, (buffer1, effect) -> buffer1.m_236818_((IdMap)BuiltInRegistries.f_256974_, effect));
        buffer.m_236835_(this.tertiary, (buffer1, effect) -> buffer1.m_236818_((IdMap)BuiltInRegistries.f_256974_, effect));
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof NewBeaconMenu) {
                NewBeaconMenu newBeaconMenu = (NewBeaconMenu)abstractContainerMenu;
                if (!player.f_36096_.m_6875_((Player)player)) {
                    BetterBeacons.LOGGER.debug("Player {} interacted with invalid menu {}", (Object)player, (Object)player.f_36096_);
                    return;
                }
                if (this.getPrimary().isPresent()) {
                    newBeaconMenu.updateEffects(this.getPrimary(), this.getSecondary(), this.getTertiary());
                } else {
                    newBeaconMenu.removeActiveEffects();
                }
            }
        });
    }

    public Optional<MobEffect> getPrimary() {
        return this.primary;
    }

    public Optional<MobEffect> getSecondary() {
        return this.secondary;
    }

    public Optional<MobEffect> getTertiary() {
        return this.tertiary;
    }
}

