/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_beacons.advancement.condition;

import com.cerbon.better_beacons.config.BBCommonConfigs;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class IsConfigEnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("better_beacons", "is_config_enabled");
    private final String config;

    public IsConfigEnabledCondition(String config) {
        this.config = config;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        return switch (this.config) {
            case "tertiary_effect" -> (Boolean)BBCommonConfigs.ENABLE_TERTIARY_EFFECTS.get();
            case "beacon_beam_redirection" -> (Boolean)BBCommonConfigs.ENABLE_BEACON_BEAM_REDIRECTION.get();
            case "beacon_beam_transparency" -> (Boolean)BBCommonConfigs.ENABLE_BEACON_BEAM_TRANSPARENCY.get();
            case "base_block_amplifier" -> (Boolean)BBCommonConfigs.ENABLE_BASE_BLOCK_AMPLIFIER.get();
            case "payment_item_range" -> (Boolean)BBCommonConfigs.ENABLE_PAYMENT_ITEM_RANGE.get();
            default -> false;
        };
    }

    public static class Serializer
    implements IConditionSerializer<IsConfigEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, IsConfigEnabledCondition value) {
            json.addProperty("config", value.config);
        }

        public IsConfigEnabledCondition read(JsonObject json) {
            return new IsConfigEnabledCondition(GsonHelper.m_13906_((JsonObject)json, (String)"config"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

