/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util.algorithm;

import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.common.util.ModUtils;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class LandFinder {
    public static Vec3 findNearestLand(Level level, Vec3 center, int size) {
        if (ModUtils.isOrbitlevel(level)) {
            return center;
        }
        for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
            if (level.m_8055_(BlockPos.m_274561_((double)center.m_7096_(), (double)y, (double)center.m_7094_())).m_60795_()) continue;
            return center;
        }
        LinkedList<Vec3> positions = new LinkedList<Vec3>();
        for (int i = -size * 16 / 2; i < size * 16 / 2; i += 16) {
            for (int j = -size * 16 / 2; j < size * 16 / 2; j += 16) {
                positions.add(new Vec3(center.m_7096_() + (double)i, center.m_7098_(), center.m_7094_() + (double)j));
            }
        }
        positions.sort((a, b) -> (int)(a.m_82554_(center) - b.m_82554_(center)));
        for (Vec3 pos : positions) {
            for (int y = level.m_141937_(); y < level.m_151558_(); ++y) {
                if (level.m_8055_(BlockPos.m_274561_((double)pos.m_7096_(), (double)y, (double)pos.m_7094_())).m_60795_()) continue;
                if (!level.f_46443_) {
                    AdAstra.LOGGER.info("Moved the lander from: " + center + " To: " + pos);
                }
                return pos;
            }
        }
        if (!level.f_46443_) {
            AdAstra.LOGGER.info("Could not find any land in the area. Spawning the lander in the original position: " + center);
        }
        return center;
    }
}

