/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util;

import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.common.data.PlanetData;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.util.ModUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class OxygenUtils {
    public static final Map<Pair<ResourceKey<Level>, BlockPos>, Set<BlockPos>> OXYGEN_LOCATIONS = new HashMap<Pair<ResourceKey<Level>, BlockPos>, Set<BlockPos>>();

    public static boolean levelHasOxygen(Level level) {
        if (!PlanetData.isOxygenated((ResourceKey<Level>)level.m_46472_())) {
            return !ModUtils.isSpacelevel(level);
        }
        return true;
    }

    public static boolean entityHasOxygen(Level level, LivingEntity entity) {
        return OxygenUtils.posHasOxygen(level, BlockPos.m_274446_((Position)entity.m_146892_()));
    }

    public static boolean posHasOxygen(Level level, BlockPos pos) {
        if (!level.m_46805_(pos)) {
            return true;
        }
        if (OxygenUtils.levelHasOxygen(level)) {
            return true;
        }
        return OxygenUtils.inDistributorBubble(level, pos);
    }

    public static boolean inDistributorBubble(Level level, BlockPos pos) {
        for (Map.Entry<Pair<ResourceKey<Level>, BlockPos>, Set<BlockPos>> entry : OXYGEN_LOCATIONS.entrySet()) {
            if (!level.m_46472_().equals(entry.getKey().getLeft()) || !entry.getValue().contains(pos)) continue;
            return true;
        }
        return false;
    }

    public static int getOxygenBlocksCount(Level level, BlockPos source) {
        return OXYGEN_LOCATIONS.getOrDefault(OxygenUtils.getOxygenSource(level, source), Set.of()).size();
    }

    public static void setEntry(Level level, BlockPos source, Set<BlockPos> entries) {
        HashSet<BlockPos> changedPositions;
        if (!level.f_46443_ && OXYGEN_LOCATIONS.containsKey(OxygenUtils.getOxygenSource(level, source)) && (changedPositions = new HashSet<BlockPos>((Collection)OXYGEN_LOCATIONS.get(OxygenUtils.getOxygenSource(level, source)))) != null && !changedPositions.isEmpty()) {
            changedPositions.removeAll(entries);
            OxygenUtils.deoxygenizeBlocks((ServerLevel)level, changedPositions, source);
        }
        OXYGEN_LOCATIONS.put(OxygenUtils.getOxygenSource(level, source), entries);
    }

    public static void removeEntry(Level level, BlockPos source) {
        OxygenUtils.setEntry(level, source, Set.of());
    }

    public static void deoxygenizeBlocks(ServerLevel level, Set<BlockPos> entries, BlockPos source) {
        try {
            if (entries == null) {
                return;
            }
            if (entries.isEmpty()) {
                return;
            }
            if (OxygenUtils.levelHasOxygen((Level)level)) {
                OXYGEN_LOCATIONS.remove(OxygenUtils.getOxygenSource((Level)level, source));
                return;
            }
            for (BlockPos pos : new HashSet<BlockPos>(entries)) {
                BlockState state = level.m_8055_(pos);
                OXYGEN_LOCATIONS.get(OxygenUtils.getOxygenSource((Level)level, source)).remove(pos);
                if (OxygenUtils.posHasOxygen((Level)level, pos) || state.m_60795_()) continue;
                Block block = state.m_60734_();
                if (block instanceof WallTorchBlock && !block.equals(Blocks.f_50140_)) {
                    level.m_46597_(pos, (BlockState)((Block)ModBlocks.WALL_EXTINGUISHED_TORCH.get()).m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)((Direction)state.m_61143_((Property)WallTorchBlock.f_58119_))));
                    continue;
                }
                if (!(!(block instanceof TorchBlock) || block.equals(Blocks.f_50139_) || block.equals(Blocks.f_50140_) || block.equals(Blocks.f_50174_) || block.equals(Blocks.f_50123_))) {
                    level.m_46597_(pos, ((Block)ModBlocks.EXTINGUISHED_TORCH.get()).m_49966_());
                    continue;
                }
                if (block instanceof CandleCakeBlock) {
                    level.m_46597_(pos, (BlockState)block.m_49966_().m_61124_((Property)CandleCakeBlock.f_152850_, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (block instanceof CandleBlock) {
                    level.m_46597_(pos, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)CandleBlock.f_152790_, (Comparable)((Integer)state.m_61143_((Property)CandleBlock.f_152790_)))).m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (block instanceof FireBlock) {
                    level.m_7471_(pos, false);
                    continue;
                }
                if (block instanceof CampfireBlock) {
                    level.m_46597_(pos, (BlockState)((BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CampfireBlock.f_51230_, (Comparable)((Direction)state.m_61143_((Property)CampfireBlock.f_51230_))));
                    continue;
                }
                if (block instanceof GrassBlock) {
                    level.m_46597_(pos, Blocks.f_50493_.m_49966_());
                    continue;
                }
                if (block instanceof BushBlock || block instanceof CactusBlock || block instanceof VineBlock) {
                    level.m_7471_(pos, true);
                    continue;
                }
                if (block instanceof FarmBlock) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(0)));
                    continue;
                }
                if (!state.m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                if (!block.equals(ModBlocks.CRYO_FUEL_BLOCK.get())) {
                    if (ModUtils.getWorldTemperature((Level)level) < 0.0f) {
                        level.m_46597_(pos, Blocks.f_50126_.m_49966_());
                        continue;
                    }
                    level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    continue;
                }
                if (!state.m_61138_((Property)BlockStateProperties.f_61362_)) continue;
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
            }
        }
        catch (UnsupportedOperationException e) {
            AdAstra.LOGGER.error("Error deoxygenizing blocks");
            e.printStackTrace();
        }
    }

    private static Pair<ResourceKey<Level>, BlockPos> getOxygenSource(Level level, BlockPos source) {
        return Pair.of((Object)level.m_46472_(), (Object)source);
    }
}

