/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.networking.packet.messages;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import earth.terrarium.ad_astra.common.util.ModUtils;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public record ServerboundTeleportToPlanetPacket(ResourceLocation id) implements Packet<ServerboundTeleportToPlanetPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("ad_astra", "teleport_to_planet");
    public static final Handler HANDLER = new Handler();

    private static ResourceKey<Level> getlevel(ResourceLocation id) {
        ResourceKey targetDimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)id);
        if (targetDimension.m_135782_().equals((Object)new ResourceLocation("ad_astra", "earth"))) {
            targetDimension = Level.f_46428_;
        }
        return targetDimension;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ServerboundTeleportToPlanetPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<ServerboundTeleportToPlanetPacket> {
        private Handler() {
        }

        public void encode(ServerboundTeleportToPlanetPacket packet, FriendlyByteBuf buf) {
            buf.m_130085_(packet.id);
        }

        public ServerboundTeleportToPlanetPacket decode(FriendlyByteBuf buf) {
            return new ServerboundTeleportToPlanetPacket(buf.m_130281_());
        }

        public PacketContext handle(ServerboundTeleportToPlanetPacket packet) {
            return (player, level) -> {
                List<String> disabledPlanets = List.of(AdAstraConfig.disabledPlanets.split(","));
                if (!disabledPlanets.contains(packet.id().toString())) {
                    if (player.m_20202_() instanceof Rocket) {
                        ModUtils.teleportToLevel(ServerboundTeleportToPlanetPacket.getlevel(packet.id()), (Entity)player);
                    } else if (player.m_36337_()) {
                        ModUtils.teleportPlayer(ServerboundTeleportToPlanetPacket.getlevel(packet.id()), (ServerPlayer)player);
                    }
                }
            };
        }
    }
}

