/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.item.vehicle;

import earth.terrarium.ad_astra.common.entity.vehicle.Rover;
import earth.terrarium.ad_astra.common.item.vehicle.VehicleItem;
import earth.terrarium.ad_astra.common.registry.ModEntityTypes;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidItemHandler;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RoverItem
extends VehicleItem {
    public RoverItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!level.f_46443_) {
            CompoundTag nbt;
            BlockPos pos = context.m_8083_();
            Player player = context.m_43723_();
            if (player == null) {
                return InteractionResult.FAIL;
            }
            for (int x = pos.m_123341_() - 1; x < pos.m_123341_() + 2; ++x) {
                for (int y = pos.m_123342_() + 1; y < pos.m_123342_() + 4; ++y) {
                    for (int z = pos.m_123343_() - 1; z < pos.m_123343_() + 2; ++z) {
                        BlockPos testBlockPos = new BlockPos(x, y, z);
                        BlockState testBlock = level.m_8055_(testBlockPos);
                        if (!testBlock.m_60838_((BlockGetter)level, testBlockPos) || testBlock.m_60734_() instanceof LiquidBlock) continue;
                        return InteractionResult.FAIL;
                    }
                }
            }
            ItemStackHolder roverStack = new ItemStackHolder(player.m_21120_(context.m_43724_()));
            Rover rover = new Rover((EntityType)ModEntityTypes.TIER_1_ROVER.get(), level);
            AABB scanAbove = new AABB((double)(pos.m_123341_() - 2), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - 2), (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 2));
            List entities = level.m_6443_(Rover.class, scanAbove, entity -> true);
            if (!entities.isEmpty()) {
                return InteractionResult.PASS;
            }
            PlatformFluidItemHandler fluidItemHandler = FluidHooks.getItemFluidManager((ItemStack)roverStack.getStack());
            if (fluidItemHandler.extractFluid(roverStack, fluidItemHandler.getFluidInTank(0), true).getFluidAmount() > 0L) {
                rover.getTank().insertFluid(fluidItemHandler.extractFluid(roverStack, fluidItemHandler.getFluidInTank(0), false), false);
            }
            if ((nbt = roverStack.getStack().m_41784_()).m_128441_("Inventory")) {
                rover.getInventory().m_7797_(nbt.m_128437_("Inventory", 10));
            }
            rover.m_146922_(player.m_146908_());
            rover.m_146884_(context.m_43720_().m_82520_(0.0, 0.0, 1.0));
            level.m_7967_((Entity)rover);
            level.m_5594_(null, pos, SoundEvents.f_12104_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (roverStack.isDirty()) {
                player.m_21008_(context.m_43724_(), roverStack.getStack());
            }
            player.m_21120_(context.m_43724_()).m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public long getTankSize() {
        return FluidHooks.buckets((double)3.0);
    }
}

