/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.compat.rei.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.ad_astra.client.screen.GuiUtil;
import earth.terrarium.ad_astra.client.screen.util.ScreenUtils;
import earth.terrarium.ad_astra.common.compat.rei.util.REIUtils;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.util.Mth;

public class EnergyBarWidget
extends BurningFire {
    protected Rectangle bounds;
    protected final boolean increasing;
    protected double animationDuration = -1.0;
    protected final NumberAnimator<Float> darkBackgroundAlpha = ValueAnimator.ofFloat().withConvention(() -> Float.valueOf(REIRuntime.getInstance().isDarkThemeEnabled() ? 1.0f : 0.0f), ValueAnimator.typicalTransitionTime()).asFloat();

    public EnergyBarWidget(Point point, boolean increasing) {
        this.bounds = new Rectangle(new Rectangle(point.x, point.y, 13, 46));
        this.increasing = increasing;
    }

    public double getAnimationDuration() {
        return this.animationDuration;
    }

    public void setAnimationDuration(double animationDurationMS) {
        this.animationDuration = animationDurationMS;
        if (this.animationDuration <= 0.0) {
            this.animationDuration = -1.0;
        }
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.darkBackgroundAlpha.update((double)delta);
        this.renderBackground(graphics, false, 1.0f);
        if (((Float)this.darkBackgroundAlpha.value()).floatValue() > 0.0f) {
            this.renderBackground(graphics, true, ((Float)this.darkBackgroundAlpha.value()).floatValue());
        }
    }

    public void renderBackground(GuiGraphics graphics, boolean dark, float alpha) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        ScreenUtils.addTexture(graphics, this.bounds.x - 2, this.bounds.y - 6, 17, 61, REIUtils.ENERGY_EMPTY_TEXTURE);
        double ratio = (double)(this.bounds.height - Mth.m_14165_((double)((double)System.currentTimeMillis() / (this.animationDuration / (double)this.bounds.height) % (double)this.bounds.height))) / (double)this.bounds.height;
        if (this.increasing) {
            GuiUtil.drawVertical(graphics, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, GuiUtil.ENERGY_TEXTURE, 1.0 - ratio);
        } else {
            GuiUtil.drawVertical(graphics, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, GuiUtil.ENERGY_TEXTURE, ratio);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }
}

