/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.pipe;

import earth.terrarium.ad_astra.common.block.BasicEntityBlock;
import earth.terrarium.ad_astra.common.block.Wrenchable;
import earth.terrarium.ad_astra.common.block.pipe.InteractablePipe;
import earth.terrarium.ad_astra.common.block.pipe.Pipe;
import earth.terrarium.ad_astra.common.block.pipe.PipeDuctBlock;
import earth.terrarium.ad_astra.common.block.pipe.PipeState;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.registry.ModSoundEvents;
import earth.terrarium.botarium.common.energy.util.EnergyHooks;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBlock
extends BasicEntityBlock
implements SimpleWaterloggedBlock,
Pipe,
Wrenchable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<PipeState> UP = EnumProperty.m_61587_((String)"up", PipeState.class);
    public static final EnumProperty<PipeState> DOWN = EnumProperty.m_61587_((String)"down", PipeState.class);
    public static final EnumProperty<PipeState> NORTH = EnumProperty.m_61587_((String)"north", PipeState.class);
    public static final EnumProperty<PipeState> EAST = EnumProperty.m_61587_((String)"east", PipeState.class);
    public static final EnumProperty<PipeState> SOUTH = EnumProperty.m_61587_((String)"south", PipeState.class);
    public static final EnumProperty<PipeState> WEST = EnumProperty.m_61587_((String)"west", PipeState.class);
    public static final Map<Direction, EnumProperty<PipeState>> DIRECTIONS = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(Direction.UP, UP);
        map.put(Direction.DOWN, DOWN);
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
    });
    private final Map<BlockState, VoxelShape> shapes = new HashMap<BlockState, VoxelShape>();
    private final long transferRate;
    private final PipeType type;

    public PipeBlock(long transferRate, double size, PipeType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(UP, (Comparable)((Object)PipeState.NONE))).m_61124_(DOWN, (Comparable)((Object)PipeState.NONE))).m_61124_(NORTH, (Comparable)((Object)PipeState.NONE))).m_61124_(EAST, (Comparable)((Object)PipeState.NONE))).m_61124_(SOUTH, (Comparable)((Object)PipeState.NONE))).m_61124_(WEST, (Comparable)((Object)PipeState.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.f_49792_.m_61056_().forEach(state -> this.shapes.put((BlockState)state, PipeBlock.createVoxelShape(state, size)));
        this.transferRate = transferRate;
        this.type = type;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack item = player.m_21120_(hand);
        if (item.m_150930_((Item)ModItems.WRENCH.get())) {
            this.handleWrench(level, pos, state, hit.m_82434_(), player, hit.m_82450_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    private boolean checkCompat(Level level, BlockPos offset) {
        Block block = level.m_8055_(offset).m_60734_();
        if (block instanceof PipeBlock) {
            PipeBlock pipe = (PipeBlock)block;
            if (this.getType() == PipeType.FLUID_PIPE) {
                return pipe.getType() == PipeType.FLUID_PIPE;
            }
            if (this.getType() == PipeType.CABLE) {
                return pipe.getType() == PipeType.CABLE;
            }
        } else {
            block = level.m_8055_(offset).m_60734_();
            if (block instanceof PipeDuctBlock) {
                PipeDuctBlock pipe = (PipeDuctBlock)block;
                if (this.getType() == PipeType.FLUID_PIPE) {
                    return pipe.equals(ModBlocks.FLUID_PIPE_DUCT.get());
                }
                if (this.getType() == PipeType.CABLE) {
                    return pipe.equals(ModBlocks.CABLE_DUCT.get());
                }
            }
        }
        return false;
    }

    protected void updatePipeState(Level level, BlockPos pos, Direction direction) {
        if (!level.f_46443_) {
            BlockPos offset = pos.m_121945_(direction);
            BlockEntity entity = level.m_7702_(offset);
            BlockState blockState = level.m_8055_(pos);
            Optional value = blockState.m_61145_((Property)DIRECTIONS.get(direction));
            if (value.isEmpty()) {
                return;
            }
            if (entity != null && (this.checkCompat(level, offset) || (this.type == PipeType.FLUID_PIPE ? FluidHooks.safeGetBlockFluidManager((BlockEntity)entity, (Direction)direction).orElse(null) : EnergyHooks.safeGetBlockEnergyManager((BlockEntity)entity, (Direction)direction).orElse(null)) != null)) {
                if (value.get() == PipeState.NONE) {
                    level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)DIRECTIONS.get(direction), (Comparable)((Object)PipeState.NORMAL)), 3);
                }
                if (level.m_8055_(offset).m_60734_().equals(this)) {
                    level.m_7731_(offset, (BlockState)level.m_8055_(offset).m_61124_((Property)DIRECTIONS.get(direction.m_122424_()), (Comparable)((Object)PipeState.NORMAL)), 3);
                }
            } else if (value.get() == PipeState.NORMAL) {
                level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)DIRECTIONS.get(direction), (Comparable)((Object)PipeState.NONE)), 3);
            }
        }
    }

    public void updatePipeState(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            for (Direction direction : Direction.values()) {
                this.updatePipeState(level, pos, direction);
            }
        }
    }

    @Override
    public long getTransferRate() {
        return this.transferRate;
    }

    public PipeType getType() {
        return this.type;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_().equals(Fluids.f_76193_)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        this.updatePipeState((Level)level, pos, direction);
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (entityLevel, blockPos, blockState, blockEntity) -> {
            if (blockEntity instanceof InteractablePipe) {
                InteractablePipe pipe = (InteractablePipe)blockEntity;
                pipe.pipeTick();
            }
        };
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(level, pos, state, placer, itemStack);
        this.updatePipeState(level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.getOrDefault(state, Shapes.m_83144_());
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)(this.type == PipeType.FLUID_PIPE ? Component.m_237110_((String)"item.ad_astra.fluid_transfer_rate.tooltip", (Object[])new Object[]{FluidHooks.toMillibuckets((long)this.getTransferRate())}) : Component.m_237110_((String)"item.ad_astra.energy_transfer_rate.tooltip", (Object[])new Object[]{this.getTransferRate()})));
    }

    public BlockState togglePipeState(BlockState state, EnumProperty<PipeState> property, Player user) {
        state = (BlockState)state.m_61122_(property);
        switch ((PipeState)((Object)state.m_61143_(property))) {
            case NORMAL: {
                user.m_5661_((Component)Component.m_237115_((String)"info.ad_astra.normal"), true);
                break;
            }
            case INSERT: {
                user.m_5661_((Component)Component.m_237115_((String)"info.ad_astra.insert"), true);
                break;
            }
            case EXTRACT: {
                user.m_5661_((Component)Component.m_237115_((String)"info.ad_astra.extract"), true);
                break;
            }
            case NONE: {
                user.m_5661_((Component)Component.m_237115_((String)"info.ad_astra.none"), true);
            }
        }
        return state;
    }

    public static Optional<Direction> getDirectionByVec(Vec3 hit, BlockPos pos) {
        Vec3 relativePos = hit.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        if (relativePos.f_82479_ < 0.125) {
            return Optional.of(Direction.WEST);
        }
        if (relativePos.f_82479_ > 0.875) {
            return Optional.of(Direction.EAST);
        }
        if (relativePos.f_82481_ < 0.125) {
            return Optional.of(Direction.NORTH);
        }
        if (relativePos.f_82481_ > 0.875) {
            return Optional.of(Direction.SOUTH);
        }
        if (relativePos.f_82480_ < 0.125) {
            return Optional.of(Direction.DOWN);
        }
        if (relativePos.f_82480_ > 0.875) {
            return Optional.of(Direction.UP);
        }
        return Optional.empty();
    }

    @Override
    public void handleWrench(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        if (!level.f_46443_) {
            EnumProperty<PipeState> property = DIRECTIONS.get(PipeBlock.getDirectionByVec(hitPos, pos).orElse(user.m_6144_() ? side.m_122424_() : side));
            level.m_6933_(pos, this.togglePipeState(state, property, user), 3, 0);
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.WRENCH.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static VoxelShape createVoxelShape(BlockState state, double size) {
        VoxelShape shape = Shapes.m_83048_((double)size, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size));
        if (state.m_61143_(UP) != PipeState.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)size, (double)size, (double)(1.0 - size), (double)1.0, (double)(1.0 - size)));
        }
        if (state.m_61143_(DOWN) != PipeState.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)0.0, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (state.m_61143_(NORTH) != PipeState.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)size, (double)0.0, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (state.m_61143_(EAST) != PipeState.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)size, (double)size, (double)1.0, (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (state.m_61143_(SOUTH) != PipeState.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)1.0));
        }
        if (state.m_61143_(WEST) != PipeState.NONE) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        return shape;
    }

    public static enum PipeType {
        CABLE,
        FLUID_PIPE;

    }
}

