/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.pipe;

import earth.terrarium.ad_astra.common.block.pipe.InteractablePipe;
import earth.terrarium.ad_astra.common.block.pipe.Pipe;
import earth.terrarium.ad_astra.common.block.pipe.PipeBlock;
import earth.terrarium.ad_astra.common.block.pipe.PipeDuctBlock;
import earth.terrarium.ad_astra.common.block.pipe.PipeState;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidHandler;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;

public class FluidPipeBlockEntity
extends BlockEntity
implements InteractablePipe<PlatformFluidHandler> {
    private final List<InteractablePipe.Node<PlatformFluidHandler>> consumers = new ArrayList<InteractablePipe.Node<PlatformFluidHandler>>();
    private InteractablePipe.Node<PlatformFluidHandler> source;

    public FluidPipeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.FLUID_PIPE.get(), pos, state);
    }

    @Override
    public boolean supportsAutoExtract() {
        return true;
    }

    @Override
    public boolean canConnectTo(BlockEntity next, Direction direction, BlockPos pos) {
        return true;
    }

    @Override
    public void insertInto(PlatformFluidHandler consumer, Direction direction, BlockPos pos) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.m_58900_();
        BlockState state2 = this.f_58857_.m_8055_(pos);
        if (state.m_60795_() || state2.m_60795_()) {
            return;
        }
        PlatformFluidHandler input = null;
        PlatformFluidHandler output = null;
        if (!(state.m_60734_() instanceof PipeDuctBlock) && !(state2.m_60734_() instanceof PipeDuctBlock)) {
            if (this.getSource().storage() == null || this.getConsumers().isEmpty()) {
                return;
            }
            Optional optionalPipeState = state.m_61145_((Property)PipeBlock.DIRECTIONS.get(this.getSource().direction()));
            Optional optionalPipeState2 = state2.m_61145_((Property)PipeBlock.DIRECTIONS.get(direction));
            if (optionalPipeState.isEmpty() || optionalPipeState2.isEmpty()) {
                return;
            }
            PipeState pipeState = (PipeState)((Object)optionalPipeState.get());
            PipeState pipeState2 = (PipeState)((Object)optionalPipeState2.get());
            if (pipeState == PipeState.INSERT && pipeState2 == PipeState.INSERT) {
                return;
            }
            if (pipeState == PipeState.EXTRACT && pipeState2 == PipeState.EXTRACT) {
                return;
            }
            if (pipeState == PipeState.NONE || pipeState2 == PipeState.NONE) {
                return;
            }
            if (pipeState2 == PipeState.INSERT || pipeState == PipeState.EXTRACT) {
                input = this.source.storage();
                output = consumer;
            } else if (pipeState2 == PipeState.EXTRACT || pipeState == PipeState.INSERT) {
                input = consumer;
                output = this.source.storage();
            } else {
                return;
            }
        }
        if (input == null || output == null) {
            return;
        }
        for (FluidHolder fluid : input.getFluidTanks()) {
            if (fluid.isEmpty()) continue;
            FluidHolder transfer = FluidHooks.newFluidHolder((Fluid)fluid.getFluid(), (long)Math.min(((PipeBlock)this.m_58900_().m_60734_()).getTransferRate(), fluid.getFluidAmount()), (CompoundTag)fluid.getCompound());
            FluidHooks.moveFluid(input, output, (FluidHolder)transfer);
        }
    }

    @Override
    public PlatformFluidHandler getInteraction(Level level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            return FluidHooks.safeGetBlockFluidManager((BlockEntity)blockEntity, (Direction)direction).orElse(null);
        }
        return null;
    }

    @Override
    public InteractablePipe.Node<PlatformFluidHandler> getSource() {
        return this.source;
    }

    @Override
    public void setSource(InteractablePipe.Node<PlatformFluidHandler> source) {
        this.source = source;
    }

    @Override
    public void clearSource() {
        this.source = null;
    }

    @Override
    public List<InteractablePipe.Node<PlatformFluidHandler>> getConsumers() {
        return this.consumers;
    }

    @Override
    public int getWorkTime() {
        return 5;
    }

    @Override
    public Level getPipelevel() {
        return this.f_58857_;
    }

    @Override
    public long getTransferAmount() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof Pipe) {
            Pipe pipe = (Pipe)block;
            return pipe.getTransferRate();
        }
        return 0L;
    }

    @Override
    public BlockPos getPipePos() {
        return this.m_58899_();
    }
}

