/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.AbstractMachineBlock;
import earth.terrarium.ad_astra.common.block.machine.entity.FluidMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.OxygenDistributorConfig;
import earth.terrarium.ad_astra.common.recipe.OxygenConversionRecipe;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModParticleTypes;
import earth.terrarium.ad_astra.common.screen.menu.OxygenDistributorMenu;
import earth.terrarium.ad_astra.common.util.FluidUtils;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import earth.terrarium.ad_astra.common.util.algorithm.FloodFiller3D;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OxygenDistributorBlockEntity
extends FluidMachineBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer> {
    private WrappedBlockEnergyContainer energyContainer;
    private int oxygenFillCheckTicks = OxygenDistributorConfig.refreshTicks;
    private boolean showOxygen = false;

    public OxygenDistributorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.OXYGEN_DISTRIBUTOR.get(), blockPos, blockState);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.showOxygen = nbt.m_128471_("ShowOxygen");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("ShowOxygen", this.showOxygen);
    }

    public boolean shouldShowOxygen() {
        return this.showOxygen;
    }

    public void setShowOxygen(boolean value) {
        this.showOxygen = value;
    }

    @Override
    public long getInputTankCapacity() {
        return OxygenDistributorConfig.tankSize;
    }

    @Override
    public long getOutputTankCapacity() {
        return OxygenDistributorConfig.tankSize;
    }

    @Override
    public Predicate<FluidHolder> getInputFilter() {
        return f -> OxygenConversionRecipe.getRecipes(this.m_58904_()).stream().anyMatch(r -> r.matches(f.getFluid()));
    }

    @Override
    public int getInventorySize() {
        return 2;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new OxygenDistributorMenu(syncId, inv, this);
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 1;
    }

    public int getMaxBlockChecks() {
        return OxygenDistributorConfig.maxBlockChecks;
    }

    public long getFluidToExtract(long oxygenBlocks, boolean client) {
        long value = (long)((double)(FluidHooks.buckets((double)1.0) / 1000L * oxygenBlocks / 60L) * OxygenDistributorConfig.oxygenMultiplier);
        if (client) {
            return value;
        }
        return value == 0L ? 1L : value;
    }

    public long getEnergyToConsume(long oxygenBlocks, boolean client) {
        long value = (long)((double)oxygenBlocks * OxygenDistributorConfig.energyMultiplier / 75.0);
        if (client) {
            return value;
        }
        return value == 0L ? 1L : value;
    }

    public void extractResources() {
        long oxygenBlocks = OxygenUtils.getOxygenBlocksCount(this.f_58857_, this.m_58899_());
        long amountOfFluidToExtract = this.getFluidToExtract(oxygenBlocks, false);
        long amountOfEnergyToConsume = this.getEnergyToConsume(oxygenBlocks, false);
        if (this.f_58857_.m_46467_() % 20L == 0L) {
            this.getFluidContainer().extractFluid(FluidHooks.newFluidHolder((Fluid)this.getOutputTank().getFluid(), (long)amountOfFluidToExtract, null), false);
        }
        if (this.getEnergyStorage().internalExtract(amountOfEnergyToConsume, false) > 0L) {
            ModUtils.spawnForcedParticles((ServerLevel)this.m_58904_(), (SimpleParticleType)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.03);
        }
    }

    public boolean canDistribute(int oxygenBlocks) {
        long amountOfFluidToExtract = this.getFluidToExtract(oxygenBlocks, false);
        long amountOfEnergyToConsume = this.getEnergyToConsume(oxygenBlocks, false);
        if (this.getOutputTank().isEmpty()) {
            return false;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.POWERED)).booleanValue()) {
            return false;
        }
        if (this.getEnergyStorage().internalExtract(amountOfEnergyToConsume, true) == 0L) {
            return false;
        }
        if (this.getOutputTank().getFluid().equals(Fluids.f_76191_)) {
            return false;
        }
        return this.getOutputTank().getFluidAmount() >= amountOfFluidToExtract;
    }

    @Override
    public void tick() {
        ItemStack insertSlot = (ItemStack)this.getItems().get(0);
        ItemStack extractSlot = (ItemStack)this.getItems().get(1);
        if (!this.f_58857_.f_46443_) {
            if (!insertSlot.m_41619_() && extractSlot.m_41613_() < extractSlot.m_41741_() && FluidHooks.isFluidContainingItem((ItemStack)insertSlot)) {
                FluidUtils.insertItemFluidToTank((FluidContainer)this.getFluidContainer(), this, 0, 1, 0, f -> OxygenConversionRecipe.getRecipes(this.f_58857_).stream().anyMatch(r -> r.matches((Fluid)f)));
                FluidUtils.extractTankFluidToItem(this.getDoubleFluidTank().getInput(), this, 0, 1, 0, f -> true);
            }
            if (this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L) {
                List<OxygenConversionRecipe> recipes = OxygenConversionRecipe.getRecipes(this.f_58857_);
                if (FluidUtils.convertFluid(this.getDoubleFluidTank(), recipes, FluidHooks.buckets((double)1.0) / 10L)) {
                    this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                }
            }
        }
        if (this.oxygenFillCheckTicks >= OxygenDistributorConfig.refreshTicks) {
            this.runAlgorithm();
            this.oxygenFillCheckTicks = 0;
        } else {
            ++this.oxygenFillCheckTicks;
        }
        if (!this.f_58857_.f_46443_) {
            boolean active = OxygenUtils.getOxygenBlocksCount(this.f_58857_, this.m_58899_()) > 0;
            this.setActive(active);
            if (active) {
                this.extractResources();
            }
        }
    }

    public void runAlgorithm() {
        if (this.f_58857_.m_5776_() ? (Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.LIT) == false : this.getOutputTank().getFluidAmount() <= 0L && this.getEnergyStorage().getStoredEnergy() <= 0L) {
            return;
        }
        Set<BlockPos> positions = FloodFiller3D.run(this.f_58857_, this.f_58858_);
        if (this.canDistribute(positions.size())) {
            OxygenUtils.setEntry(this.f_58857_, this.f_58858_, positions);
        } else if (!this.f_58857_.m_5776_()) {
            OxygenUtils.removeEntry(this.f_58857_, this.m_58899_());
        }
        if (this.shouldShowOxygen()) {
            this.spawnParticles(positions);
        }
    }

    public void spawnParticles(Set<BlockPos> positions) {
        if (!this.f_58857_.m_5776_() && ((Boolean)this.m_58900_().m_61143_((Property)AbstractMachineBlock.LIT)).booleanValue()) {
            for (BlockPos pos : positions) {
                ModUtils.spawnForcedParticles((ServerLevel)this.m_58904_(), (SimpleParticleType)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public long getEnergyPerTick() {
        return OxygenDistributorConfig.fluidConversionEnergyPerTick;
    }

    @Override
    public long getMaxCapacity() {
        return this.getEnergyStorage().getMaxCapacity();
    }

    @Override
    public WrappedBlockEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(OxygenDistributorConfig.maxEnergy))) : this.energyContainer;
    }
}

