/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.entity.FluidMachineBlockEntity;
import earth.terrarium.ad_astra.common.config.FuelRefineryConfig;
import earth.terrarium.ad_astra.common.recipe.FuelConversionRecipe;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.screen.menu.ConversionMenu;
import earth.terrarium.ad_astra.common.util.FluidUtils;
import earth.terrarium.botarium.common.energy.base.BotariumEnergyBlock;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuelRefineryBlockEntity
extends FluidMachineBlockEntity
implements BotariumEnergyBlock<WrappedBlockEnergyContainer> {
    public FuelRefineryBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.FUEL_REFINERY.get(), blockPos, blockState);
    }

    @Override
    public long getInputTankCapacity() {
        return FuelRefineryConfig.tankSize;
    }

    @Override
    public long getOutputTankCapacity() {
        return FuelRefineryConfig.tankSize;
    }

    @Override
    public Predicate<FluidHolder> getInputFilter() {
        return f -> FuelConversionRecipe.getRecipes(this.m_58904_()).stream().anyMatch(r -> r.matches(f.getFluid()));
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot == 0;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 1 || slot == 3;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new ConversionMenu(syncId, inv, this);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.m_5776_()) {
            ItemStack insertSlot = (ItemStack)this.getItems().get(0);
            ItemStack extractSlot = (ItemStack)this.getItems().get(1);
            ItemStack outputInsertSlot = (ItemStack)this.getItems().get(2);
            ItemStack outputExtractSlot = (ItemStack)this.getItems().get(3);
            if (!insertSlot.m_41619_() && extractSlot.m_41613_() < extractSlot.m_41741_() && FluidHooks.isFluidContainingItem((ItemStack)insertSlot)) {
                FluidUtils.insertItemFluidToTank(this.getDoubleFluidTank().getInput(), this, 0, 1, 0, f -> FuelConversionRecipe.getRecipes(this.f_58857_).stream().anyMatch(r -> r.matches((Fluid)f)));
                FluidUtils.extractTankFluidToItem(this.getDoubleFluidTank().getInput(), this, 0, 1, 0, f -> true);
            }
            if (!outputInsertSlot.m_41619_() && outputExtractSlot.m_41613_() < outputExtractSlot.m_41741_()) {
                FluidUtils.extractTankFluidToItem(this.getDoubleFluidTank().getOutput(), this, 2, 3, 0, f -> true);
            }
            if (this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), true) > 0L) {
                List<FuelConversionRecipe> recipes = FuelConversionRecipe.getRecipes(this.f_58857_);
                if (FluidUtils.convertFluid(this.getDoubleFluidTank(), recipes, FluidHooks.buckets((double)1.0) / 50L)) {
                    this.getEnergyStorage().internalExtract(this.getEnergyPerTick(), false);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public long getEnergyPerTick() {
        return FuelRefineryConfig.energyPerTick;
    }

    @Override
    public WrappedBlockEnergyContainer getEnergyStorage() {
        return this.energyContainer == null ? (this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(FuelRefineryConfig.maxEnergy))) : this.energyContainer;
    }
}

