/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.utils.ScreenUtils;
import com.teamresourceful.resourcefullib.common.color.Color;
import earth.terrarium.ad_astra.client.screen.util.ButtonType;
import earth.terrarium.ad_astra.client.screen.util.PlanetSelectionScreen;
import earth.terrarium.ad_astra.common.data.ButtonColor;
import earth.terrarium.ad_astra.common.data.Planet;
import earth.terrarium.ad_astra.common.util.ColourUtils;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class CustomButton
extends Button {
    public static final ResourceLocation LARGE_BUTTON_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/buttons/large_button.png");
    public static final ResourceLocation BUTTON_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/buttons/button.png");
    public static final ResourceLocation SMALL_BUTTON_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/buttons/small_button.png");
    public static final ResourceLocation STEEL_BUTTON_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/buttons/steel_button.png");
    private final int startY;
    private final Component label;
    private final ButtonType buttonSize;
    private final Color buttonColourLightened;
    private final Color buttonColour;
    private final Planet planetInfo;
    private final PlanetSelectionScreen.TooltipType tooltip;
    public boolean doScissor = true;

    public CustomButton(int x, int y, Component label, ButtonType size, ButtonColor buttonColor, PlanetSelectionScreen.TooltipType tooltip, Planet planetInfo, Button.OnPress onPress) {
        super(x, y, size.getWidth(), size.getHeight(), CustomButton.adjustText(label), onPress, Button.f_252438_);
        this.startY = y;
        this.label = label;
        this.buttonSize = size;
        Color colour = buttonColor.getColor();
        this.buttonColourLightened = ColourUtils.lighten(colour, 0.1f);
        this.buttonColour = colour;
        this.tooltip = tooltip;
        this.planetInfo = planetInfo;
    }

    public static Component adjustText(Component label) {
        int length = label.getString().length();
        if (length > 12 && length != 13) {
            return Component.m_130674_((String)(label.m_130668_(12) + "."));
        }
        return label;
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        this.m_253211_(this.startY);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.f_93624_) {
            Minecraft minecraft = Minecraft.m_91087_();
            double scale = minecraft.m_91268_().m_85449_();
            int screenHeight = minecraft.m_91268_().m_85446_();
            int scissorY = (int)((double)(screenHeight / 2 - 83) * scale);
            boolean over = this.m_5953_(mouseX, mouseY);
            Color color = over ? this.buttonColourLightened : this.buttonColour;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(5.0f, 0.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.enableDepthTest();
            if (this.doScissor) {
                RenderSystem.enableScissor((int)0, (int)scissorY, (int)((int)(215.0 * scale)), (int)((int)(127.0 * scale)));
            }
            RenderSystem.setShaderColor((float)color.getFloatRed(), (float)color.getFloatGreen(), (float)color.getFloatBlue(), (float)this.buttonColour.getFloatAlpha());
            ResourceLocation texture = switch (this.buttonSize) {
                default -> throw new IncompatibleClassChangeError();
                case ButtonType.LARGE -> LARGE_BUTTON_TEXTURE;
                case ButtonType.NORMAL -> BUTTON_TEXTURE;
                case ButtonType.SMALL -> SMALL_BUTTON_TEXTURE;
                case ButtonType.STEEL -> STEEL_BUTTON_TEXTURE;
            };
            graphics.m_280163_(texture, this.buttonSize.equals((Object)ButtonType.LARGE) ? this.m_252754_() - 2 : this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.buttonSize.getWidth(), this.buttonSize.getHeight());
            this.drawText(graphics, minecraft);
            if (this.doScissor) {
                RenderSystem.disableScissor();
            }
            if (this.m_5953_(mouseX, mouseY)) {
                this.renderTooltips(minecraft);
            }
            graphics.m_280168_().m_85849_();
            RenderSystem.disableDepthTest();
        }
    }

    public void drawText(GuiGraphics graphics, Minecraft minecraft) {
        int colour = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        graphics.m_280168_().m_85836_();
        float scale = 0.9f;
        graphics.m_280168_().m_85841_(scale, scale, scale);
        int x = this.buttonSize.equals((Object)ButtonType.LARGE) ? this.m_252754_() - 2 : this.m_252754_();
        graphics.m_280168_().m_252880_(4.0f + (float)x / 9.5f, (float)this.m_252907_() / 8.5f, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280653_(minecraft.f_91062_, this.m_6035_(), x + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, colour | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        graphics.m_280168_().m_85849_();
    }

    public int getStartY() {
        return this.startY;
    }

    private void renderTooltips(Minecraft minecraft) {
        LinkedList<Component> textEntries = new LinkedList<Component>();
        switch (this.tooltip) {
            case GALAXY: {
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7b" + this.label.getString())));
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a75" + PlanetSelectionScreen.GALAXY_TEXT.getString())));
                break;
            }
            case SOLAR_SYSTEM: {
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7b" + this.label.getString())));
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.SOLAR_SYSTEM_TEXT.getString())));
                break;
            }
            case CATEGORY: {
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.CATEGORY_TEXT.getString() + ": \u00a7a" + this.label.getString())));
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.PROVIDED_TEXT.getString() + ": \u00a7b" + Component.m_237115_((String)("item.ad_astra.tier_" + this.planetInfo.rocketTier() + "_rocket")).getString())));
                break;
            }
            case PLANET: {
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + (this.planetInfo.parentWorld() == null ? PlanetSelectionScreen.PLANET_TEXT.getString() : PlanetSelectionScreen.MOON_TEXT.getString()))));
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.GRAVITY_TEXT.getString() + ": \u00a73" + this.planetInfo.gravity() + " m/s")));
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.OXYGEN_TEXT.getString() + ": \u00a7" + (this.planetInfo.hasOxygen() ? "a" + PlanetSelectionScreen.OXYGEN_TRUE_TEXT.getString() : "c" + PlanetSelectionScreen.OXYGEN_FALSE_TEXT.getString()))));
                String temperatureColour = "\u00a7a";
                if (this.planetInfo.temperature() > 50.0f) {
                    temperatureColour = "\u00a76";
                } else if (this.planetInfo.temperature() < -20.0f) {
                    temperatureColour = "\u00a71";
                }
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": " + temperatureColour + " " + this.planetInfo.temperature() + " \u00b0C")));
                break;
            }
            case SPACE_STATION: {
                PlanetSelectionScreen currentScreen = (PlanetSelectionScreen)minecraft.f_91080_;
                textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.ITEM_REQUIREMENT_TEXT.getString())));
                if (currentScreen == null) {
                    return;
                }
                currentScreen.ingredients.forEach(ingredient -> {
                    boolean isEnough = ((ItemStack)ingredient.getFirst()).m_41613_() >= (Integer)ingredient.getSecond();
                    textEntries.add(Component.m_130674_((String)("\u00a7" + (isEnough ? "a" : "c") + ((ItemStack)ingredient.getFirst()).m_41613_() + "/" + ingredient.getSecond() + " \u00a73" + ((ItemStack)ingredient.getFirst()).m_41786_().getString())));
                });
                textEntries.add(Component.m_130674_((String)"\u00a7c----------------"));
                break;
            }
        }
        if (this.tooltip.equals((Object)PlanetSelectionScreen.TooltipType.ORBIT) || this.tooltip.equals((Object)PlanetSelectionScreen.TooltipType.SPACE_STATION)) {
            textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.TYPE_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.ORBIT_TEXT.getString())));
            textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.GRAVITY_TEXT.getString() + ": \u00a73" + PlanetSelectionScreen.NO_GRAVITY_TEXT.getString())));
            textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.OXYGEN_TEXT.getString() + ": \u00a7c " + PlanetSelectionScreen.OXYGEN_FALSE_TEXT.getString())));
            textEntries.add(Component.m_130674_((String)("\u00a79" + PlanetSelectionScreen.TEMPERATURE_TEXT.getString() + ": \u00a71 -270.0 \u00b0C")));
        }
        ScreenUtils.setTooltip(textEntries);
    }
}

