/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.renderer.block.flag;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FlagTexture
extends SimpleTexture {
    private static final HttpClient CLIENT = HttpClient.newBuilder().build();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation DEFAULT_FLAG = new ResourceLocation("ad_astra", "textures/block/flag/warning_flag.png");
    private final HttpRequest request;
    private boolean loaded;
    private CompletableFuture<?> loader;

    public FlagTexture(String url) {
        super(DEFAULT_FLAG);
        this.request = HttpRequest.newBuilder().uri(URI.create(url)).header("User-Agent", "Ad Astra (Minecraft Mod)").build();
    }

    public static ResourceLocation getTextureId(String url) {
        return new ResourceLocation("ad_astra", "flagtextures/" + Hashing.sha1().hashUnencodedChars((CharSequence)url));
    }

    private void upload(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85040_(0, 0, 0, true);
    }

    public void m_6704_(ResourceManager manager) {
        Minecraft.m_91087_().execute(() -> {
            if (!this.loaded) {
                try {
                    super.m_6704_(manager);
                }
                catch (IOException var3x) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.f_118129_, (Object)var3x);
                }
                this.loaded = true;
            }
        });
        if (this.loader == null) {
            this.loader = CompletableFuture.runAsync(() -> {
                try {
                    HttpResponse<InputStream> data = CLIENT.send(this.request, HttpResponse.BodyHandlers.ofInputStream());
                    if (data.statusCode() / 100 == 2) {
                        NativeImage image = this.loadTexture(data.body());
                        Minecraft.m_91087_().execute(() -> {
                            if (image != null) {
                                Minecraft.m_91087_().execute(() -> {
                                    this.loaded = true;
                                    if (!RenderSystem.isOnRenderThread()) {
                                        RenderSystem.recordRenderCall(() -> this.upload(image));
                                    } else {
                                        this.upload(image);
                                    }
                                });
                            }
                        });
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.error("Couldn't download http texture", (Throwable)e);
                }
            }, Util.m_183991_());
        }
    }

    @Nullable
    private NativeImage loadTexture(InputStream stream) {
        NativeImage nativeImage = null;
        try {
            nativeImage = NativeImage.m_85058_((InputStream)stream);
        }
        catch (Exception var4) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)var4);
        }
        return nativeImage;
    }
}

