/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.renderer.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import earth.terrarium.ad_astra.common.item.armor.ModArmourItem;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModItems;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SpaceSuitModel
extends HumanoidModel<LivingEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("ad_astra", "space_suit"), "main");
    public final ModelPart visor;
    public final ModelPart belt;
    public final ModelPart rightBoot;
    public final ModelPart leftBoot;
    private final HumanoidModel<LivingEntity> contextModel;
    private final ResourceLocation texture;
    private final EquipmentSlot slot;
    private final ItemStack stack;

    public SpaceSuitModel(ModelPart root, HumanoidModel<LivingEntity> contextModel, LivingEntity entity, EquipmentSlot slot, ItemStack stack) {
        super(root);
        this.contextModel = contextModel;
        Item item = stack.m_41720_();
        if (item instanceof ModArmourItem) {
            ModArmourItem item2 = (ModArmourItem)item;
            String armourTexture = item2.getArmorTexture(stack, (Entity)entity, slot, null);
            this.texture = new ResourceLocation(Objects.requireNonNullElse(armourTexture, ""));
        } else {
            this.texture = new ResourceLocation("");
        }
        this.slot = slot;
        this.stack = stack;
        this.visor = root.m_171324_("visor");
        this.belt = root.m_171324_("belt");
        this.rightBoot = root.m_171324_("left_boot");
        this.leftBoot = root.m_171324_("right_boot");
        this.setVisible();
    }

    public static VertexConsumer getVertex(RenderType renderLayer, boolean hasEnchantments) {
        MultiBufferSource.BufferSource vertexConsumerProvider = Minecraft.m_91087_().m_91269_().m_110104_();
        return hasEnchantments ? VertexMultiConsumer.m_86168_((VertexConsumer)vertexConsumerProvider.m_6299_(RenderType.m_110496_()), (VertexConsumer)vertexConsumerProvider.m_6299_(renderLayer)) : vertexConsumerProvider.m_6299_(renderLayer);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition visor = modelPartData.m_171599_("visor", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat = modelPartData.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.f_171404_);
        PartDefinition body = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(24, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition belt = modelPartData.m_171599_("belt", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-0.5f, (float)0.0f));
        PartDefinition backpack = body.m_171599_("backpack", CubeListBuilder.m_171558_().m_171514_(32, 44).m_171488_(-6.0f, -8.0f, -2.0f, 12.0f, 16.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)5.0f));
        PartDefinition right_arm = modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r1 = right_arm.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)-1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition cube_r2 = left_arm.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171480_().m_171488_(-2.0f, -6.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.m_171423_((float)1.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.7f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition right_boot = modelPartData.m_171599_("right_boot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)).m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_boot = modelPartData.m_171599_("left_boot", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)).m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, @NotNull VertexConsumer vertices, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.f_102608_ = this.contextModel.f_102608_;
        this.f_102609_ = this.contextModel.f_102609_;
        this.f_102610_ = this.contextModel.f_102610_;
        this.f_102815_ = this.contextModel.f_102815_;
        this.f_102816_ = this.contextModel.f_102816_;
        this.f_102817_ = this.contextModel.f_102817_;
        this.f_102808_.m_104315_(this.contextModel.f_102808_);
        this.visor.m_104315_(this.contextModel.f_102808_);
        this.f_102810_.m_104315_(this.contextModel.f_102810_);
        this.belt.m_104315_(this.contextModel.f_102810_);
        this.f_102811_.m_104315_(this.contextModel.f_102811_);
        this.f_102812_.m_104315_(this.contextModel.f_102812_);
        this.f_102814_.m_104315_(this.contextModel.f_102814_);
        this.f_102813_.m_104315_(this.contextModel.f_102813_);
        this.rightBoot.m_104315_(this.contextModel.f_102813_);
        this.leftBoot.m_104315_(this.contextModel.f_102814_);
        poseStack.m_85836_();
        if (this.f_102610_) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        }
        int decimal = ((SpaceSuit)this.stack.m_41720_()).m_41121_(this.stack);
        float r = (float)(decimal >> 16 & 0xFF) / 255.0f;
        float g = (float)(decimal >> 8 & 0xFF) / 255.0f;
        float b = (float)(decimal & 0xFF) / 255.0f;
        Minecraft minecraft = Minecraft.m_91087_();
        MultiBufferSource.BufferSource provider = minecraft.m_91269_().m_110104_();
        if (!this.stack.m_150930_((Item)ModItems.SPACE_HELMET.get())) {
            this.f_102808_.m_104306_(poseStack, vertices, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            this.visor.m_104306_(poseStack, provider.m_6299_(RenderType.m_110473_((ResourceLocation)this.texture)), packedLight, packedOverlay, r, g, b, 1.0f);
        } else {
            this.f_102808_.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
            this.visor.m_104306_(poseStack, provider.m_6299_(RenderType.m_110473_((ResourceLocation)this.texture)), packedLight, packedOverlay, r, g, b, 1.0f);
        }
        this.f_102810_.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
        this.f_102811_.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
        this.f_102812_.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
        this.belt.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
        this.f_102813_.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
        this.f_102814_.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
        this.rightBoot.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
        this.leftBoot.m_104306_(poseStack, vertices, packedLight, packedOverlay, r, g, b, 1.0f);
        poseStack.m_85849_();
    }

    private void setVisible() {
        this.m_8009_(false);
        switch (this.slot) {
            case HEAD: {
                this.f_102808_.f_104207_ = true;
                this.visor.f_104207_ = true;
                break;
            }
            case CHEST: {
                this.f_102810_.f_104207_ = true;
                this.f_102811_.f_104207_ = true;
                this.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                this.belt.f_104207_ = true;
                this.f_102813_.f_104207_ = true;
                this.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                this.rightBoot.f_104207_ = true;
                this.leftBoot.f_104207_ = true;
                break;
            }
        }
    }

    public void m_8009_(boolean visible) {
        super.m_8009_(visible);
        this.visor.f_104207_ = visible;
        this.belt.f_104207_ = visible;
        this.rightBoot.f_104207_ = visible;
        this.leftBoot.f_104207_ = visible;
    }

    public ResourceLocation getTextureLocation() {
        return this.texture;
    }
}

