/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.forge.mixin;

import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.mixin.AccessorMountedFluidStorage;
import com.railwayteam.railways.mixin_interfaces.IFuelInventory;
import com.simibubi.create.content.contraptions.MountedFluidStorage;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MountedStorageManager.class}, remap=false)
public abstract class MountedStorageManagerMixin {
    @Shadow
    protected abstract CombinedTankWrapper wrapFluids(Collection<IFluidHandler> var1);

    @Inject(method={"createHandlers"}, at={@At(value="TAIL")})
    private void createHandler(CallbackInfo ci) {
        CombinedTankWrapper combinedTankWrapper = this.wrapFluids(((IFuelInventory)((Object)this)).railways$getFluidFuelStorage().values().stream().map(MountedFluidStorage::getFluidHandler).collect(Collectors.toList()));
        ((IFuelInventory)((Object)this)).railways$setFuelFluids(combinedTankWrapper);
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    public void read(CompoundTag nbt, Map<BlockPos, BlockEntity> presentBlockEntities, boolean clientPacket, CallbackInfo ci) {
        CombinedTankWrapper ctw = this.wrapFluids(((IFuelInventory)((Object)this)).railways$getFluidFuelStorage().values().stream().map(MountedFluidStorage::getFluidHandler).toList());
        ((IFuelInventory)((Object)this)).railways$setFuelFluids(ctw);
    }

    @Inject(method={"bindTanks"}, at={@At(value="TAIL")})
    public void bindTanks(Map<BlockPos, BlockEntity> presentBlockEntities, CallbackInfo ci) {
        ((IFuelInventory)((Object)this)).railways$getFluidFuelStorage().forEach((pos, mfs) -> {
            BlockEntity blockEntity = (BlockEntity)presentBlockEntities.get(pos);
            if (!(blockEntity instanceof FuelTankBlockEntity)) {
                return;
            }
            FuelTankBlockEntity tank = (FuelTankBlockEntity)blockEntity;
            IFluidTank tankInventory = tank.getTankInventory();
            if (tankInventory instanceof FluidTank) {
                ((FluidTank)tankInventory).setFluid(((AccessorMountedFluidStorage)mfs).railways$getTank().getFluid());
            }
            tank.getFluidLevel().startWithValue((double)tank.getFillState());
            mfs.assignBlockEntity((BlockEntity)tank);
        });
    }

    @Inject(method={"clear"}, at={@At(value="TAIL")})
    private void clear(CallbackInfo ci) {
        CombinedTankWrapper fuelFluidInventory = ((IFuelInventory)((Object)this)).railways$getFuelFluids();
        for (int i = 0; i < fuelFluidInventory.getTanks(); ++i) {
            fuelFluidInventory.drain(fuelFluidInventory.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Inject(method={"updateContainedFluid"}, at={@At(value="TAIL")})
    private void updateContainedFluid(BlockPos localPos, FluidStack containedFluid, CallbackInfo ci) {
        MountedFluidStorage mountedFuelFluidStorage = ((IFuelInventory)((Object)this)).railways$getFluidFuelStorage().get(localPos);
        if (mountedFuelFluidStorage != null) {
            mountedFuelFluidStorage.updateFluid(containedFluid);
        }
    }
}

