/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.registry;

import com.drmangotea.tfmg.CreateTFMG;
import com.drmangotea.tfmg.registry.TFMGItems;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum TFMGArmorMaterials implements ArmorMaterial
{
    STEEL(CreateTFMG.asResource("steel").toString(), 30, new int[]{3, 6, 8, 3}, 18, () -> SoundEvents.f_11679_, 2.0f, 0.1f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TFMGItems.STEEL_INGOT.get()}));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final Supplier<SoundEvent> soundEvent;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairMaterial;

    private TFMGArmorMaterials(String name, int maxDamageFactor, int[] damageReductionAmountArray, int enchantability, Supplier<SoundEvent> soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairMaterial) {
        this.name = name;
        this.maxDamageFactor = maxDamageFactor;
        this.damageReductionAmountArray = damageReductionAmountArray;
        this.enchantability = enchantability;
        this.soundEvent = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairMaterial = Suppliers.memoize(repairMaterial::get);
    }

    public int m_266425_(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> MAX_DAMAGE_ARRAY[3] * this.maxDamageFactor;
            case ArmorItem.Type.CHESTPLATE -> MAX_DAMAGE_ARRAY[2] * this.maxDamageFactor;
            case ArmorItem.Type.LEGGINGS -> MAX_DAMAGE_ARRAY[1] * this.maxDamageFactor;
            case ArmorItem.Type.BOOTS -> MAX_DAMAGE_ARRAY[0] * this.maxDamageFactor;
        };
    }

    public int m_7366_(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> this.damageReductionAmountArray[3];
            case ArmorItem.Type.CHESTPLATE -> this.damageReductionAmountArray[2];
            case ArmorItem.Type.LEGGINGS -> this.damageReductionAmountArray[1];
            case ArmorItem.Type.BOOTS -> this.damageReductionAmountArray[0];
        };
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent.get();
    }

    public Ingredient m_6230_() {
        return this.repairMaterial.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

