/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.dynamicpack.ClientDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.dynamicpack.ServerDynamicResourcesHandler;
import net.mehvahdjukaar.every_compat.misc.HardcodedStuff;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class SimpleModule
extends CompatModule {
    private final String shortId;
    private final Map<String, EntrySet<?>> entries = new LinkedHashMap();
    private final Set<Class<? extends BlockType>> affectedTypes = new HashSet<Class<? extends BlockType>>();
    protected int bloat = 0;

    public SimpleModule(String modId, String shortId) {
        super(modId);
        this.shortId = shortId;
    }

    public SimpleModule(String modId, String shortId, String myNamespace) {
        super(modId, myNamespace);
        this.shortId = shortId;
    }

    public ResourceLocation makeMyRes(String name) {
        return new ResourceLocation(this.getMyNamespace(), name);
    }

    @Override
    public Collection<Class<? extends BlockType>> getAffectedTypes() {
        return this.affectedTypes;
    }

    @Override
    public int bloatAmount() {
        return this.bloat;
    }

    public <T extends BlockType, S extends EntrySet<T>> S addEntry(S entryHolder) {
        EntrySet<?> old = this.entries.put(entryHolder.getName(), entryHolder);
        if (old != null) {
            throw new UnsupportedOperationException(String.format("This module already has an entry set with name %s", entryHolder.getName()));
        }
        this.affectedTypes.add(entryHolder.getTypeClass());
        EveryCompat.trackChildType(entryHolder.getTypeClass(), entryHolder.getChildKey(this));
        return entryHolder;
    }

    public Collection<EntrySet<?>> getEntries() {
        return this.entries.values();
    }

    public EntrySet<?> getEntry(String name) {
        EntrySet<?> e = this.entries.get(name);
        if (e == null) {
            throw new UnsupportedOperationException(String.format("This module does not have entries of type %s", name));
        }
        return e;
    }

    @Override
    public String shortenedId() {
        return this.shortId;
    }

    @Override
    public void addTranslations(ClientDynamicResourcesHandler clientDynamicResourcesHandler, AfterLanguageLoadEvent lang) {
        this.getEntries().forEach(e -> e.addTranslations(this, lang));
    }

    @Override
    public <T extends BlockType> void registerBlocks(Class<T> typeClass, Registrator<Block> registry, Collection<T> types) {
        int blockCount = 0;
        for (EntrySet<?> e : this.getEntries()) {
            if (!e.getTypeClass().isAssignableFrom(typeClass)) continue;
            this.registerBlocksTyped(registry, types, e);
            blockCount += e.getBlockCount();
        }
        this.bloat += blockCount;
        if (blockCount > 0) {
            EveryCompat.LOGGER.info("{}: registered {} {} blocks", (Object)this, (Object)blockCount, (Object)typeClass.getSimpleName());
        }
    }

    private <T extends BlockType> void registerBlocksTyped(Registrator<Block> registry, Collection<?> types, EntrySet<T> e) {
        e.registerBlocks(this, registry, types);
    }

    @Override
    public void registerItems(Registrator<Item> registry) {
        this.getEntries().forEach(e -> e.registerItems(this, registry));
    }

    @Override
    public void registerTiles(Registrator<BlockEntityType<?>> registry) {
        this.getEntries().forEach(e -> e.registerTiles(this, registry));
    }

    @Override
    public void addDynamicServerResources(ServerDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> {
            e.generateLootTables(this, (DynamicDataPack)handler.dynamicPack, manager);
            e.generateRecipes(this, (DynamicDataPack)handler.dynamicPack, manager);
            e.generateTags(this, (DynamicDataPack)handler.dynamicPack, manager);
        });
    }

    @Override
    public void addDynamicClientResources(ClientDynamicResourcesHandler handler, ResourceManager manager) {
        this.getEntries().forEach(e -> {
            block2: {
                try {
                    e.generateModels(this, handler, manager);
                }
                catch (Exception ex) {
                    EveryCompat.LOGGER.error("Failed to generate models for entry set {}:", e, (Object)ex);
                    if (!PlatHelper.isDev()) break block2;
                    throw ex;
                }
            }
        });
        this.getEntries().forEach(e -> {
            block2: {
                try {
                    e.generateTextures(this, handler, manager);
                }
                catch (Exception ex) {
                    EveryCompat.LOGGER.error("Failed to generate textures for entry set {}:", e, (Object)ex);
                    if (!PlatHelper.isDev()) break block2;
                    throw ex;
                }
            }
        });
    }

    @Override
    public void registerBlockColors(ClientHelper.BlockColorEvent event) {
        this.getEntries().forEach(e -> e.registerBlockColors(event));
    }

    @Override
    public void registerItemColors(ClientHelper.ItemColorEvent event) {
        this.getEntries().forEach(e -> e.registerItemColors(event));
    }

    @Override
    public void onClientSetup() {
        this.getEntries().forEach(EntrySet::setRenderLayer);
    }

    @Override
    public void onModSetup() {
        this.getEntries().forEach(EntrySet::setupExistingTiles);
    }

    public static void appendTileEntityBlocks(BlockEntityType<?> be, Collection<? extends Block> blocks) {
        be.f_58915_ = new HashSet(be.f_58915_);
        be.f_58915_.addAll(blocks);
    }

    @Override
    public void registerItemsToExistingTabs(RegHelper.ItemToTabEvent event) {
        this.getEntries().forEach(e -> e.registerItemsToExistingTabs(this, event));
    }

    @Override
    public <T extends BlockType> List<Item> getAllItemsOfType(T type) {
        ArrayList<Item> l = new ArrayList<Item>();
        for (EntrySet<?> entrySet : this.entries.values()) {
            Item itemOfType;
            if (!entrySet.getTypeClass().isAssignableFrom(type.getClass()) || (itemOfType = entrySet.getItemForECTab(type)) == null) continue;
            l.add(itemOfType);
        }
        return l;
    }

    @Deprecated(forRemoval=true)
    public boolean isEntryAlreadyRegistered(String name, BlockType woodType, Registry<?> registry, boolean isVanilla) {
        return this.isEntryAlreadyRegistered(name, woodType, registry);
    }

    @Deprecated(forRemoval=true)
    public boolean isEntryAlreadyRegistered(String name, BlockType woodType, Registry<?> registry, boolean isVanilla, boolean wrong) {
        return this.isEntryAlreadyRegistered(name, woodType, registry);
    }

    public boolean isEntryAlreadyRegistered(String name, BlockType woodType, Registry<?> registry) {
        LeavesType lt;
        WoodType wt;
        Boolean hardcoded;
        if (woodType.isVanilla()) {
            return true;
        }
        name = name.substring(name.lastIndexOf("/") + 1);
        String woodFrom = woodType.getNamespace();
        String slashConvention = woodFrom + "/" + name;
        String underscoreConvention = woodFrom + "_" + name;
        if (this.getAlreadySupportedMods().contains(woodFrom)) {
            return true;
        }
        if (woodType instanceof WoodType ? (hardcoded = HardcodedStuff.isWoodBlockAlreadyRegistered(name, wt = (WoodType)woodType, this.modId, this.shortenedId())) != null : woodType instanceof LeavesType && (hardcoded = HardcodedStuff.isLeavesBlockAlreadyRegistered(name, lt = (LeavesType)woodType, this.modId, this.shortenedId())) != null) {
            return hardcoded;
        }
        if (woodFrom.equals(this.modId)) {
            return true;
        }
        if (registry.m_7804_(new ResourceLocation(this.modId, name)) || registry.m_7804_(new ResourceLocation(this.modId, underscoreConvention))) {
            return true;
        }
        if (registry.m_7804_(new ResourceLocation(woodFrom, name))) {
            return true;
        }
        for (EveryCompat.CompatMod c : EveryCompat.getCompatMods()) {
            String compatModId = c.modId();
            if (!c.woodsFrom().contains(woodFrom) || !c.blocksFrom().contains(this.modId)) continue;
            if (registry.m_7804_(new ResourceLocation(compatModId, name))) {
                return true;
            }
            if (registry.m_7804_(new ResourceLocation(compatModId, slashConvention))) {
                return true;
            }
            if (!registry.m_7804_(new ResourceLocation(compatModId, underscoreConvention))) continue;
            return true;
        }
        return false;
    }
}

