/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.renderers;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.lpcamors.optical.COPartialModels;
import net.lpcamors.optical.blocks.beam_focuser.BeamFocuserBlockEntity;
import net.lpcamors.optical.blocks.optical_source.OpticalSourceBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public class BeamFocuserRenderer
extends ShaftRenderer<BeamFocuserBlockEntity> {
    public BeamFocuserRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(BeamFocuserBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        BlockState blockState = be.m_58900_();
        Direction direction = (Direction)blockState.m_61143_(OpticalSourceBlock.HORIZONTAL_FACING);
        ms.m_85836_();
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        ms.m_85837_(0.0, -0.37, 0.0);
        ms.m_85841_(1.0f, 1.1f, 1.0f);
        double k = 0.08;
        double radius = 18.0;
        double alpha = 1.25;
        if (be.processingTicks >= 5 && be.processingTicks <= be.getProcessDuration()) {
            double angle = be.getAngle(partialTicks, radius, k, alpha);
            VertexConsumer vb = buffer.m_6299_(RenderType.m_110472_());
            SuperByteBuffer focusBeam = CachedBufferer.partial((PartialModel)COPartialModels.FOCUS_BEAM, (BlockState)blockState).disableDiffuse().light(0xF000F0);
            VertexConsumer vb1 = buffer.m_6299_(this.getBeamRenderType());
            SuperByteBuffer focusBeam1 = ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)COPartialModels.FOCUS_BEAM_GLOW, (BlockState)blockState).centre()).scale(1.2f)).unCentre()).light(0xF000F0).disableDiffuse();
            Direction.Axis rotDirection = direction.m_122429_() == 0 ? direction.m_122427_().m_122434_() : direction.m_122434_();
            float rot_off = AngleHelper.rad((double)(90.0f - direction.m_122435_()));
            BeamFocuserRenderer.kineticRotationTransform((SuperByteBuffer)focusBeam, (KineticBlockEntity)be, (Direction.Axis)Direction.Axis.Y, (float)rot_off, (int)light);
            BeamFocuserRenderer.kineticRotationTransform((SuperByteBuffer)focusBeam1, (KineticBlockEntity)be, (Direction.Axis)Direction.Axis.Y, (float)rot_off, (int)light);
            BeamFocuserRenderer.kineticRotationTransform((SuperByteBuffer)focusBeam, (KineticBlockEntity)be, (Direction.Axis)rotDirection, (float)AngleHelper.rad((double)angle), (int)light);
            BeamFocuserRenderer.kineticRotationTransform((SuperByteBuffer)focusBeam1, (KineticBlockEntity)be, (Direction.Axis)rotDirection, (float)AngleHelper.rad((double)angle), (int)light);
            be.getBeamSourceInstance().optionalBeamProperties().ifPresent(beamProperties -> {
                focusBeam.color(beamProperties.color.m_123341_(), beamProperties.color.m_123342_(), beamProperties.color.m_123343_(), 255).light(0xF000F0).renderInto(ms, vb);
                focusBeam1.color(beamProperties.color.m_123341_(), beamProperties.color.m_123342_(), beamProperties.color.m_123343_(), 255).light(0xF000F0).renderInto(ms, vb1);
            });
        }
        ms.m_85849_();
    }

    private SuperByteBuffer rotateLaser(SuperByteBuffer buffer, double angle, Direction facing) {
        float pivotX = 0.5f;
        float pivotY = 0.5f;
        float pivotZ = 0.5f;
        buffer.rotateCentered(Direction.UP, (float)((double)AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122428_())) - Math.PI));
        buffer.translate((double)pivotX, (double)pivotY, (double)pivotZ);
        buffer.rotate(facing, AngleHelper.rad((double)angle));
        buffer.translate((double)(-pivotX), (double)(-pivotY), (double)(-pivotZ));
        return buffer;
    }

    public RenderType getBeamRenderType() {
        RenderType.CompositeRenderType renderType = RenderType.m_173215_((String)"create_optical:laser", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110687_(new RenderStateShard.WriteMaskStateShard(true, true)).m_110663_(new RenderStateShard.DepthTestStateShard("<=", 515)).m_110661_(new RenderStateShard.CullStateShard(false)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.f_118259_, false, true)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).m_110675_(new RenderStateShard.OutputStateShard("translucent_var", () -> {
            if (Minecraft.m_91085_()) {
                Minecraft.m_91087_().f_91060_.m_109828_().m_83947_(false);
            }
        }, () -> {
            if (Minecraft.m_91085_()) {
                Minecraft.m_91087_().m_91385_().m_83947_(false);
            }
        })).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172649_)).m_110691_(false));
        return renderType;
    }
}

