/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.optical_sensor;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Optional;
import net.lpcamors.optical.blocks.COBlocks;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.optical_sensor.OpticalSensorBlock;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.data.COLang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class OpticalSensorBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private IBeamReceiver.BeamSourceInstance beamSourceInstance = IBeamReceiver.BeamSourceInstance.empty(null);

    public OpticalSensorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_ && this.shouldUpdate()) {
            this.update();
        }
    }

    public boolean shouldUpdate() {
        IBeamReceiver.BeamSourceInstance beamSourceInstance1 = this.beamSourceInstance;
        this.beamSourceInstance = this.beamSourceInstance.checkSourceExistenceAndCompatibility((BlockEntity)this);
        return !beamSourceInstance1.equals(this.beamSourceInstance);
    }

    public void update() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.m_6596_();
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.getSignal() > 0)), 3);
        this.updateNeighbours(this.m_58900_(), this.f_58857_);
        this.sendData();
    }

    public boolean changeState(BlockPos pos, BeamHelper.BeamProperties beamProperties) {
        if (this.beamSourceInstance.optionalBeamProperties().isEmpty()) {
            this.beamSourceInstance = new IBeamReceiver.BeamSourceInstance(Optional.of(beamProperties), pos);
            this.update();
        }
        return beamProperties.equals(this.beamSourceInstance.optionalBeamProperties().orElse(null));
    }

    public Optional<BeamHelper.BeamProperties> getOptionalBeamProperties() {
        return this.beamSourceInstance.optionalBeamProperties();
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.beamSourceInstance = IBeamReceiver.BeamSourceInstance.read(compound);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.beamSourceInstance.write(compound);
    }

    public int getSignal() {
        return ((OpticalSensorBlock.Mode)((Object)this.m_58900_().m_61143_(OpticalSensorBlock.MODE))).apply(this.beamSourceInstance.optionalBeamProperties());
    }

    private void updateNeighbours(BlockState p_54681_, Level p_54682_) {
        p_54682_.m_46672_(this.m_58899_(), (Block)COBlocks.OPTICAL_SENSOR.get());
        p_54682_.m_46672_(this.m_58899_().m_121945_(((Direction)p_54681_.m_61143_((Property)DirectionalBlock.f_52588_)).m_122424_()), (Block)COBlocks.OPTICAL_SENSOR.get());
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.builder((String)"tooltip").translate("create_optical.gui.goggles.optical_sensor", new Object[0]).forGoggles(tooltip);
        Lang.text((String)"").add(COLang.Prefixes.CREATE.translate("gui.goggles.optical_sensor.mode", new Object[0]).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
        Lang.text((String)"").add(COLang.Prefixes.CREATE.translate(((OpticalSensorBlock.Mode)((Object)this.m_58900_().m_61143_(OpticalSensorBlock.MODE))).getDescriptionId(), new Object[0]).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        return true;
    }
}

