/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.optical_receptor;

import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import java.util.Locale;
import java.util.Optional;
import net.lpcamors.optical.blocks.COBlockEntities;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.IBeamSource;
import net.lpcamors.optical.blocks.optical_receptor.OpticalReceptorBlockEntity;
import net.lpcamors.optical.blocks.optical_receptor.OpticalReceptorShaper;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.items.COItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class OpticalReceptorBlock
extends DirectionalAxisKineticBlock
implements IBE<OpticalReceptorBlockEntity>,
IBeamReceiver {
    public static final OpticalReceptorShaper SHAPER = OpticalReceptorShaper.make();
    public final OpticalReceptorGearHeaviness heaviness;

    public static OpticalReceptorBlock light(BlockBehaviour.Properties properties) {
        return new OpticalReceptorBlock(properties, OpticalReceptorGearHeaviness.LIGHT);
    }

    public static OpticalReceptorBlock heavy(BlockBehaviour.Properties properties) {
        return new OpticalReceptorBlock(properties, OpticalReceptorGearHeaviness.HEAVY);
    }

    private OpticalReceptorBlock(BlockBehaviour.Properties properties, OpticalReceptorGearHeaviness heaviness) {
        super(properties);
        this.heaviness = heaviness;
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        BlockEntity blockEntity;
        super.onBlockStateChange(level, pos, oldState, newState);
        if (newState.m_60713_((Block)this) && (blockEntity = level.m_7702_(pos)) instanceof OpticalReceptorBlockEntity) {
            OpticalReceptorBlockEntity be = (OpticalReceptorBlockEntity)blockEntity;
            be.updateDirectionMap();
        }
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof OpticalReceptorBlockEntity) {
            OpticalReceptorBlockEntity opticalReceptorBlockEntity = (OpticalReceptorBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(interactionHand);
            if (stack.m_41720_().equals(COItems.OPTICAL_DEVICE.m_5456_())) {
                ItemStack stack1 = stack.m_41777_();
                stack1.m_41764_(1);
                boolean f = opticalReceptorBlockEntity.addSensor(stack1, blockHitResult.m_82434_());
                if (f) {
                    stack.m_41774_(1);
                }
                return f ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            if (player.m_6144_() && player.m_21120_(interactionHand).m_41619_()) {
                boolean f = opticalReceptorBlockEntity.removeSensor(blockHitResult.m_82434_(), Optional.of(player));
                return f ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return super.onWrenched(state, context);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        Direction face = context.m_43719_();
        BlockPos placedOnPos = context.m_8083_().m_121945_(context.m_43719_().m_122424_());
        BlockState placedOnState = world.m_8055_(placedOnPos);
        Block block = placedOnState.m_60734_();
        if (block instanceof IRotate && ((IRotate)block).hasShaftTowards((LevelReader)world, placedOnPos, placedOnState, face)) {
            boolean lookPositive;
            BlockState toPlace = this.m_49966_();
            Direction horizontalFacing = context.m_8125_();
            Direction nearestLookingDirection = context.m_7820_();
            boolean bl = lookPositive = nearestLookingDirection.m_122421_() == Direction.AxisDirection.POSITIVE;
            toPlace = face.m_122434_() == Direction.Axis.X ? (BlockState)((BlockState)toPlace.m_61124_((Property)FACING, (Comparable)(lookPositive ? Direction.NORTH : Direction.SOUTH))).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(true)) : (face.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)toPlace.m_61124_((Property)FACING, (Comparable)horizontalFacing.m_122424_())).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(horizontalFacing.m_122434_() == Direction.Axis.X)) : (BlockState)((BlockState)toPlace.m_61124_((Property)FACING, (Comparable)(lookPositive ? Direction.WEST : Direction.EAST))).m_61124_((Property)AXIS_ALONG_FIRST_COORDINATE, (Comparable)Boolean.valueOf(false)));
            return toPlace;
        }
        return super.m_5573_(context);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pNewState.m_60713_(pState.m_60734_())) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> be.sensor.forEach(itemStack -> Block.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)itemStack)));
            pLevel.m_46747_(pPos);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    protected Direction getFacingForPlacement(BlockPlaceContext context) {
        return context.m_43719_();
    }

    protected boolean getAxisAlignmentForPlacement(BlockPlaceContext context) {
        return context.m_8125_().m_122434_() != Direction.Axis.X;
    }

    public Class<OpticalReceptorBlockEntity> getBlockEntityClass() {
        return OpticalReceptorBlockEntity.class;
    }

    public BlockEntityType<? extends OpticalReceptorBlockEntity> getBlockEntityType() {
        return this.heaviness.id == 2 ? (BlockEntityType)COBlockEntities.CAPACITY_OPTICAL_RECEPTOR.get() : (BlockEntityType)COBlockEntities.OPTICAL_RECEPTOR.get();
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return SHAPER.get((Direction)p_60555_.m_61143_((Property)FACING), (Boolean)p_60555_.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE));
    }

    @Override
    public boolean useCenteredIncidence() {
        return true;
    }

    @Override
    public void receive(IBeamSource iBeamSource, BlockState state, BlockPos lastPos, BeamHelper.BeamProperties beamProperties, int lastIndex) {
        OpticalReceptorBlockEntity be = (OpticalReceptorBlockEntity)this.getBlockEntity((BlockGetter)iBeamSource.m_58904_(), lastPos);
        if (be == null) {
            return;
        }
        if (be.m_58898_() && be.m_58904_().f_46443_) {
            return;
        }
        BlockPos pos = be.m_58899_();
        if (be.changeState(beamProperties.direction, iBeamSource.m_58899_(), beamProperties)) {
            iBeamSource.addDependent(pos);
        }
    }

    public static boolean canPlaceSensorAt(Direction direction, BlockState state) {
        boolean f1;
        boolean axisAlong = (Boolean)state.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE);
        Direction stateDirection = (Direction)state.m_61143_((Property)FACING);
        boolean bl = stateDirection.m_122434_().m_122479_() && stateDirection.m_122434_() == Direction.Axis.X == axisAlong ? true : (f1 = false);
        if (f1) {
            return direction.m_122434_().m_122479_();
        }
        return !direction.equals((Object)((Direction)state.m_61143_((Property)FACING)).m_122424_()) && !direction.m_122434_().equals((Object)OpticalReceptorBlock.getStaticRotationAxis(state));
    }

    public static Direction.Axis getStaticRotationAxis(BlockState state) {
        Direction.Axis pistonAxis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        boolean alongFirst = (Boolean)state.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE);
        if (pistonAxis == Direction.Axis.X) {
            return alongFirst ? Direction.Axis.Y : Direction.Axis.Z;
        }
        if (pistonAxis == Direction.Axis.Y) {
            return alongFirst ? Direction.Axis.X : Direction.Axis.Z;
        }
        if (pistonAxis == Direction.Axis.Z) {
            return alongFirst ? Direction.Axis.X : Direction.Axis.Y;
        }
        throw new IllegalStateException("Unknown axis??");
    }

    public static enum OpticalReceptorGearHeaviness implements StringRepresentable
    {
        LIGHT(0),
        MEDIUM(1),
        HEAVY(2);

        private final int id;

        private OpticalReceptorGearHeaviness(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String m_7912_() {
            return "create_optical.gear_heaviness." + this.name().toLowerCase(Locale.ROOT);
        }
    }
}

