/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.encased_mirror;

import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class EncasedMirrorBlockEntity
extends KineticBlockEntity {
    public float rotVelocity;
    public float oAngle;
    public float angle;
    private static final float ANGLE_RANGE = 80.0f;
    @Nullable
    private State state = null;

    public EncasedMirrorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        float actualSpeed = this.getSpeed();
        this.rotVelocity = actualSpeed / 4.285714f;
        this.oAngle = this.angle;
        this.angle = Mth.m_14036_((float)(this.angle + this.rotVelocity), (float)0.0f, (float)90.0f);
        float i = this.angle / 9.0f;
        this.state = (double)i >= 9.5 ? State.PERPENDICULAR : ((double)i <= 0.5 ? State.PARALLEL : null);
    }

    @Nullable
    public State getState() {
        return this.state;
    }

    public boolean isRotating() {
        return this.oAngle != this.angle;
    }

    public float getIndependentAngle(float partialTicks) {
        return Mth.m_14036_((float)(this.angle + partialTicks * this.rotVelocity), (float)0.0f, (float)90.0f);
    }

    @Nullable
    public Direction getReflectedDirection(Direction dir, BlockState state) {
        if (this.getState() == null) {
            return null;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        Direction direction = null;
        if (facing.m_122434_().m_122478_()) {
            if (dir.m_122434_().m_122479_()) {
                direction = dir.m_122428_();
                if (dir.m_122434_().equals((Object)Direction.Axis.X)) {
                    direction = direction.m_122424_();
                }
            }
        } else if (dir.m_122434_().m_122478_()) {
            direction = facing.m_122434_().equals((Object)Direction.Axis.X) ? Direction.NORTH : Direction.WEST;
            if (facing.m_122421_().equals((Object)Direction.AxisDirection.POSITIVE)) {
                direction = direction.m_122424_();
            }
            if (dir.m_122421_().equals((Object)Direction.AxisDirection.NEGATIVE)) {
                direction = direction.m_122424_();
            }
        } else if (!dir.m_122434_().equals((Object)facing.m_122434_())) {
            direction = Direction.UP;
            if (facing.m_122421_().equals((Object)Direction.AxisDirection.NEGATIVE)) {
                direction = direction.m_122424_();
            }
            if (dir.m_122421_().equals((Object)Direction.AxisDirection.NEGATIVE)) {
                direction = direction.m_122424_();
            }
        }
        if (direction != null && !this.getState().isParallel()) {
            direction = direction.m_122424_();
        }
        return direction;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128441_("AngularPosition")) {
            this.angle = compound.m_128457_("AngularPosition");
        }
        if (compound.m_128441_("AngularVelocity")) {
            this.rotVelocity = compound.m_128457_("AngularVelocity");
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("AngularPosition", this.angle);
        compound.m_128350_("AngularVelocity", this.rotVelocity);
    }

    public static enum State {
        PARALLEL(0),
        PERPENDICULAR(1);

        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public State getPerpendicular() {
            if (this.getAngle() == 0.0) {
                return PERPENDICULAR;
            }
            return PARALLEL;
        }

        public boolean isParallel() {
            return this.equals((Object)PARALLEL);
        }

        public double getAngle() {
            return this.equals((Object)PARALLEL) ? 0.0 : 1.5707963267948966;
        }
    }
}

