/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.beam_focuser;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.beam_focuser.BeamFocuserBlock;
import net.lpcamors.optical.blocks.beam_focuser.BeamFocuserHelper;
import net.lpcamors.optical.blocks.beam_focuser.BlockFocusingBehaviour;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.lpcamors.optical.data.COLang;
import net.lpcamors.optical.recipes.FocusingRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BeamFocuserBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public static final int PROCESSING_TICK = 40;
    public FilteringBehaviour filtering;
    protected BeltProcessingBehaviour beltProcessing;
    protected BlockFocusingBehaviour customProcess;
    public int processingTicks = -1;
    public int baseProcessingDuration = 40;
    private IBeamReceiver.BeamSourceInstance beamSourceInstance = IBeamReceiver.BeamSourceInstance.empty(null);

    public BeamFocuserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.shouldUpdate()) {
            this.update();
        }
        if (!this.isVirtual() && (this.speed == 0.0f || this.beamSourceInstance.optionalBeamProperties().isEmpty())) {
            this.processingTicks = -1;
        }
        if (this.processingTicks >= 0) {
            --this.processingTicks;
        }
    }

    public double getAngle(float partialTicks, double radius, double k, double alpha) {
        int cycles = (int)Math.ceil((double)Math.abs(this.getSpeed()) / 64.0);
        double t = (double)((cycles + 1) * 2) * Math.PI * (double)(-partialTicks + (float)this.processingTicks - (float)this.getProcessDuration()) / (k * (double)(5 - this.getProcessDuration()));
        double angle = radius * Math.tan(alpha * Math.cos(k * t)) / Math.tan(alpha);
        return angle;
    }

    public IBeamReceiver.BeamSourceInstance getBeamSourceInstance() {
        return this.beamSourceInstance;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new FocuserFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.beltProcessing = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters(this::onItemReceived).whileItemHeld(this::whenItemHeld);
        behaviours.add((BlockEntityBehaviour)this.beltProcessing);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.SPOUT, AllAdvancements.FOODS});
    }

    public boolean shouldUpdate() {
        IBeamReceiver.BeamSourceInstance beamSourceInstance1 = this.beamSourceInstance;
        this.beamSourceInstance = this.beamSourceInstance.checkSourceExistenceAndCompatibility((BlockEntity)this);
        return !beamSourceInstance1.equals(this.beamSourceInstance);
    }

    public void update() {
        this.m_6596_();
        this.sendData();
    }

    public boolean changeState(BlockPos pos, BeamHelper.BeamProperties beamProperties) {
        if (this.beamSourceInstance.optionalBeamProperties().isEmpty()) {
            this.beamSourceInstance = new IBeamReceiver.BeamSourceInstance(Optional.of(beamProperties), pos);
            this.update();
        }
        return this.beamSourceInstance.optionalBeamProperties().get().equals(beamProperties);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, -2.0, 0.0);
    }

    public int getProcessDuration() {
        return (int)((float)this.baseProcessingDuration * this.getSpeedDurationMultiplier());
    }

    public float getSpeedDurationMultiplier() {
        return (288.0f - Math.abs(this.getSpeed())) / 256.0f;
    }

    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        ItemStack out;
        if (this.speed == 0.0f || this.beamSourceInstance.optionalBeamProperties().isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.processingTicks != -1 && this.processingTicks != 5) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        RecipeWrapper w = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(2));
        w.m_6836_(0, transported.stack);
        w.m_6836_(1, this.filtering.getFilter());
        BeamHelper.BeamType beamType = this.beamSourceInstance.optionalBeamProperties().get().beamType;
        Optional<FocusingRecipe> recipe = BeamFocuserHelper.canBeProcessed(this.f_58857_, w, beamType);
        if (recipe.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.processingTicks == -1) {
            this.baseProcessingDuration = recipe.get().getProcessingDuration();
            this.processingTicks = this.getProcessDuration() + 5;
            this.notifyUpdate();
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        List results = recipe.get().rollResults();
        transported.stack.m_41774_(1);
        ItemStack itemStack = out = results.isEmpty() ? ItemStack.f_41583_ : (ItemStack)results.get(0);
        if (!out.m_41619_()) {
            ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = out;
            if (!transported.stack.m_41619_()) {
                held = transported.copy();
            }
            outList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)held));
        }
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.speed == 0.0f || this.beamSourceInstance.optionalBeamProperties().isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        RecipeWrapper w = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(2));
        w.m_6836_(0, transported.stack);
        w.m_6836_(1, this.filtering.getFilter());
        BeamHelper.BeamType beamType = this.beamSourceInstance.optionalBeamProperties().get().beamType;
        Optional<FocusingRecipe> recipe = BeamFocuserHelper.canBeProcessed(this.f_58857_, w, beamType);
        if (recipe.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.beamSourceInstance = IBeamReceiver.BeamSourceInstance.read(compound);
        this.processingTicks = compound.m_128451_("ProcessingTicks");
        this.baseProcessingDuration = compound.m_128451_("ProcessingDuration");
        if (!clientPacket) {
            return;
        }
        if (this.m_58898_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
        }
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("ProcessingTicks", this.processingTicks);
        compound.m_128405_("ProcessingDuration", this.baseProcessingDuration);
        this.beamSourceInstance.write(compound);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.builder((String)"tooltip").translate("create_optical.gui.goggles.beam_properties", new Object[0]).forGoggles(tooltip);
        if (this.beamSourceInstance != null && this.beamSourceInstance.optionalBeamProperties().isPresent()) {
            Lang.text((String)"").add(COLang.Prefixes.CREATE.translate("gui.goggles.beam_type", new Object[0]).m_130940_(ChatFormatting.GRAY)).forGoggles(tooltip);
            Lang.text((String)"").add(COLang.Prefixes.CREATE.translate(this.beamSourceInstance.optionalBeamProperties().get().beamType.getDescriptionId(), new Object[0]).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public static class FocuserFilterSlot
    extends ValueBoxTransform.Sided {
        protected boolean isSideActive(BlockState state, Direction direction) {
            return ((Direction)state.m_61143_(BeamFocuserBlock.HORIZONTAL_FACING)).m_122427_().m_122434_() == direction.m_122434_();
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)10.0, (double)15.5);
        }
    }
}

