/*
 * Decompiled with CFR 0.152.
 */
package net.lpcamors.optical.blocks.beam_condenser;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Arrays;
import net.lpcamors.optical.COShapes;
import net.lpcamors.optical.blocks.COBlockEntities;
import net.lpcamors.optical.blocks.IBeamReceiver;
import net.lpcamors.optical.blocks.IBeamSource;
import net.lpcamors.optical.blocks.beam_condenser.BeamCondenserBlockEntity;
import net.lpcamors.optical.blocks.optical_source.BeamHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BeamCondenserBlock
extends HorizontalDirectionalBlock
implements IBeamReceiver,
IBE<BeamCondenserBlockEntity> {
    public BeamCondenserBlock(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState p_60555_, @NotNull BlockGetter p_60556_, @NotNull BlockPos p_60557_, @NotNull CollisionContext p_60558_) {
        return COShapes.BEAM_CONDENSER.get((Direction)p_60555_.m_61143_((Property)f_54117_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.m_7926_(p_49915_.m_61104_(new Property[]{f_54117_}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferredFacing = this.getPreferredFacing(context);
        if (preferredFacing == null) {
            preferredFacing = (Direction)Arrays.stream(context.m_6232_()).filter(direction -> direction.m_122434_().m_122479_()).toArray()[0];
        }
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)(context.m_43723_() != null && context.m_43723_().m_6144_() ? preferredFacing : preferredFacing.m_122424_()));
    }

    @Override
    public boolean useCenteredIncidence() {
        return false;
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction prefferedSide = null;
        for (Direction side : Iterate.directions) {
            BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(side));
            if (!(blockState.m_60734_() instanceof IRotate) || !((IRotate)blockState.m_60734_()).hasShaftTowards((LevelReader)context.m_43725_(), context.m_8083_().m_121945_(side), blockState, side.m_122424_())) continue;
            if (prefferedSide != null && prefferedSide.m_122434_() != side.m_122434_()) {
                prefferedSide = null;
                break;
            }
            prefferedSide = side;
        }
        return prefferedSide != null && prefferedSide.m_122434_().m_122478_() ? null : prefferedSide;
    }

    @Override
    public void receive(IBeamSource iBeamSource, BlockState state, BlockPos lastPos, BeamHelper.BeamProperties beamProperties, int lastIndex) {
        Direction direction = beamProperties.direction;
        BeamCondenserBlockEntity be = (BeamCondenserBlockEntity)this.getBlockEntity((BlockGetter)iBeamSource.m_58904_(), lastPos);
        if (iBeamSource instanceof BeamCondenserBlockEntity || be == null || ((Direction)state.m_61143_((Property)f_54117_)).equals((Object)direction.m_122424_())) {
            return;
        }
        if (be.m_58898_() && be.m_58904_().f_46443_) {
            return;
        }
        BlockPos pos = be.m_58899_();
        if (be.changeState(direction, iBeamSource.m_58899_(), beamProperties)) {
            iBeamSource.addDependent(pos);
        }
    }

    public boolean m_7357_(BlockState p_60475_, BlockGetter p_60476_, BlockPos p_60477_, PathComputationType p_60478_) {
        return super.m_7357_(p_60475_, p_60476_, p_60477_, p_60478_);
    }

    public Class<BeamCondenserBlockEntity> getBlockEntityClass() {
        return BeamCondenserBlockEntity.class;
    }

    public BlockEntityType<? extends BeamCondenserBlockEntity> getBlockEntityType() {
        return (BlockEntityType)COBlockEntities.BEAM_CONDENSER.get();
    }
}

