/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.rewards.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.rewards.Reward;
import net.puffish.skillsmod.api.rewards.RewardContext;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.Result;

public class ScoreboardReward
implements Reward {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("scoreboard");
    private final String objectiveName;

    private ScoreboardReward(String objectiveName) {
        this.objectiveName = objectiveName;
    }

    public static void register() {
        SkillsAPI.registerRewardWithData(ID, ScoreboardReward::create);
    }

    private static Result<ScoreboardReward, Failure> create(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(ScoreboardReward::create);
    }

    private static Result<ScoreboardReward, Failure> create(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional<String> optScoreboard = rootObject.getString("scoreboard").ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new ScoreboardReward(optScoreboard.orElseThrow()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    @Override
    public void update(ServerPlayer player, RewardContext context) {
        Scoreboard scoreboard = player.m_36329_();
        Objective objective = scoreboard.m_83469_(this.objectiveName);
        if (objective != null) {
            scoreboard.m_83471_(player.m_6302_(), objective).m_83402_(context.getCount());
        }
    }

    @Override
    public void dispose(MinecraftServer server) {
    }
}

