/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.rewards.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.rewards.Reward;
import net.puffish.skillsmod.api.rewards.RewardContext;
import net.puffish.skillsmod.api.utils.Failure;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;

public class AttributeReward
implements Reward {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("attribute");
    private final List<UUID> uuids = new ArrayList<UUID>();
    private final Attribute attribute;
    private final float value;
    private final AttributeModifier.Operation operation;

    private AttributeReward(Attribute attribute, float value, AttributeModifier.Operation operation) {
        this.attribute = attribute;
        this.value = value;
        this.operation = operation;
    }

    public static void register() {
        SkillsAPI.registerRewardWithData(ID, AttributeReward::create);
    }

    private static Result<AttributeReward, Failure> create(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(AttributeReward::create);
    }

    private static Result<AttributeReward, Failure> create(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optAttribute = rootObject.get("attribute").andThen(attributeElement -> JsonParseUtils.parseAttribute(attributeElement).andThen(attribute -> {
            if (DefaultAttributes.m_22297_((EntityType)EntityType.f_20532_).m_22258_(attribute)) {
                return Result.success(attribute);
            }
            return Result.failure(attributeElement.getPath().createFailure("Expected a valid player attribute"));
        })).ifFailure(failures::add).getSuccess();
        Optional<Float> optValue = rootObject.getFloat("value").ifFailure(failures::add).getSuccess();
        Optional optOperation = rootObject.get("operation").andThen(JsonParseUtils::parseAttributeOperation).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new AttributeReward((Attribute)optAttribute.orElseThrow(), optValue.orElseThrow().floatValue(), (AttributeModifier.Operation)optOperation.orElseThrow()));
        }
        return Result.failure(Failure.fromMany(failures));
    }

    private void createMissingUUIDs(int count) {
        while (this.uuids.size() < count) {
            this.uuids.add(UUID.randomUUID());
        }
    }

    @Override
    public void update(ServerPlayer player, RewardContext context) {
        int count = context.getCount();
        AttributeInstance instance = Objects.requireNonNull(player.m_21051_(this.attribute));
        this.createMissingUUIDs(count);
        for (int i = 0; i < this.uuids.size(); ++i) {
            UUID uuid = this.uuids.get(i);
            if (instance.m_22111_(uuid) == null) {
                if (i >= count) continue;
                instance.m_22118_(new AttributeModifier(uuid, "", (double)this.value, this.operation));
                continue;
            }
            if (i < count) continue;
            instance.m_22120_(uuid);
        }
    }

    @Override
    public void dispose(MinecraftServer server) {
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            AttributeInstance instance = Objects.requireNonNull(player.m_21051_(this.attribute));
            for (UUID uuid : this.uuids) {
                instance.m_22120_(uuid);
            }
        }
        this.uuids.clear();
    }
}

