/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.puffish.skillsmod.access.EntityAttributeInstanceAccess;
import net.puffish.skillsmod.server.setup.SkillsAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    private static final double VANILLA_KNOCKBACK = 0.4;

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void injectAtCreatePlayerAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(SkillsAttributes.STAMINA).m_22266_(SkillsAttributes.FORTUNE).m_22266_(SkillsAttributes.RANGED_DAMAGE).m_22266_(SkillsAttributes.MELEE_DAMAGE).m_22266_(SkillsAttributes.HEALING).m_22266_(SkillsAttributes.JUMP).m_22266_(SkillsAttributes.RESISTANCE).m_22266_(SkillsAttributes.MINING_SPEED).m_22266_(SkillsAttributes.SPRINTING_SPEED).m_22266_(SkillsAttributes.KNOCKBACK);
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;onTargetDamaged(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/Entity;)V")})
    private void injectAtAttack(Entity target, CallbackInfo ci) {
        Player player = (Player)this;
        EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(SkillsAttributes.KNOCKBACK);
        double knockback = attribute.computeIncreasedValueForInitial(0.4) - 0.4;
        float yaw = player.m_146908_() * ((float)Math.PI / 180);
        float sin = Mth.m_14031_((float)yaw);
        float cos = Mth.m_14089_((float)yaw);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.m_147240_(knockback, (double)sin, (double)(-cos));
        } else {
            target.m_5997_((double)(-sin) * knockback, 0.0, (double)cos * knockback);
        }
    }

    @Inject(method={"getMovementSpeed()F"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectAtGetMovementSpeed(CallbackInfoReturnable<Float> cir) {
        Player player = (Player)this;
        if (player.m_20142_()) {
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(SkillsAttributes.SPRINTING_SPEED);
            cir.setReturnValue((Object)Float.valueOf((float)attribute.computeIncreasedValueForInitial(cir.getReturnValueF())));
        }
    }
}

