/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.access.DamageSourceAccess;
import net.puffish.skillsmod.access.EntityAttributeInstanceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.builtin.TakeDamageExperienceSource;
import net.puffish.skillsmod.server.setup.SkillsAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private int entityDroppedXp = 0;

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyVariableAtDamage(float damage, DamageSource source) {
        if (damage < 0.0f) {
            return damage;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (source.m_269533_(DamageTypeTags.f_268524_)) {
                attribute = (EntityAttributeInstanceAccess)player.m_21051_(SkillsAttributes.RANGED_DAMAGE);
                damage = (float)attribute.computeIncreasedValueForInitial(damage);
            } else {
                attribute = (EntityAttributeInstanceAccess)player.m_21051_(SkillsAttributes.MELEE_DAMAGE);
                damage = (float)attribute.computeIncreasedValueForInitial(damage);
            }
        }
        return damage;
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void injectAtDamage(DamageSource source, float damage, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            SkillsAPI.visitExperienceSources(serverPlayer, experienceSource -> {
                if (experienceSource instanceof TakeDamageExperienceSource) {
                    TakeDamageExperienceSource takeDamageExperienceSource = (TakeDamageExperienceSource)experienceSource;
                    return takeDamageExperienceSource.getValue(serverPlayer, damage, source);
                }
                return 0;
            });
        }
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyVariableAtHeal(float amount) {
        if (amount < 0.0f) {
            return amount;
        }
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(SkillsAttributes.HEALING);
            amount = (float)attribute.computeIncreasedValueForInitial(amount);
        }
        return amount;
    }

    @Inject(method={"getJumpVelocity"}, at={@At(value="RETURN")}, cancellable=true)
    private void injectAtGetJumpVelocity(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(SkillsAttributes.JUMP);
            cir.setReturnValue((Object)Float.valueOf((float)attribute.computeIncreasedValueForInitial(cir.getReturnValueF())));
        }
    }

    @ModifyVariable(method={"computeFallDamage"}, at=@At(value="STORE"), ordinal=2)
    private float modifyVariableAtComputeFallDamage(float reduction) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(SkillsAttributes.JUMP);
            reduction = (float)((double)reduction + (attribute.computeIncreasedValueForInitial(1.0) - 1.0) * 10.0);
        }
        return reduction;
    }

    @Inject(method={"drop"}, at={@At(value="TAIL")})
    private void injectAtDrop(DamageSource source, CallbackInfo ci) {
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LivingEntity entity2 = (LivingEntity)this;
            ItemStack weapon = ((DamageSourceAccess)source).getWeapon().orElse(ItemStack.f_41583_);
            WorldChunkAccess worldChunk = (WorldChunkAccess)entity2.m_9236_().m_46745_(entity2.m_20183_());
            worldChunk.antiFarmingCleanupOutdated();
            SkillsAPI.visitExperienceSources(player, experienceSource -> {
                if (experienceSource instanceof KillEntityExperienceSource) {
                    KillEntityExperienceSource entityExperienceSource = (KillEntityExperienceSource)experienceSource;
                    if (entityExperienceSource.getAntiFarming().map(worldChunk::antiFarmingAddAndCheck).orElse(true).booleanValue()) {
                        return entityExperienceSource.getValue(player, entity2, weapon, source, this.entityDroppedXp);
                    }
                }
                return 0;
            });
        }
    }

    @ModifyArg(method={"dropXp"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    private int injectAtDropXp(int droppedXp) {
        this.entityDroppedXp = droppedXp;
        return droppedXp;
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectAtModifyAppliedDamage(CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (cir.getReturnValueF() < 1.1342745E38f) {
                EntityAttributeInstanceAccess attribute = (EntityAttributeInstanceAccess)player.m_21051_(SkillsAttributes.RESISTANCE);
                cir.setReturnValue((Object)Float.valueOf(Math.max(0.0f, (float)attribute.computeDecreasedValueForInitial(cir.getReturnValueF()))));
            }
        }
    }
}

