/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.builtin.CraftItemExperienceSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"onCraft"}, at={@At(value="HEAD")})
    private void injectAtOnCraft(Level world, Player player, int amount, CallbackInfo ci) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SkillsAPI.visitExperienceSources(serverPlayer, experienceSource -> {
                if (experienceSource instanceof CraftItemExperienceSource) {
                    CraftItemExperienceSource craftItemExperienceSource = (CraftItemExperienceSource)experienceSource;
                    return craftItemExperienceSource.getValue(serverPlayer, (ItemStack)this) * amount;
                }
                return 0;
            });
        }
    }
}

